/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal.config;

import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.module.tls.internal.DefaultTlsContextFactory;

public class DefaultTlsContextFactoryObjectFactory
extends AbstractComponentFactory<DefaultTlsContextFactory> {
    private String name;
    private TlsContextKeyStoreConfiguration keyStore;
    private TlsContextTrustStoreConfiguration trustStore;
    private String enabledProtocols;
    private String enabledCipherSuites;

    public void setName(String name) {
        this.name = name;
    }

    public void setKeyStore(TlsContextKeyStoreConfiguration keyStore) {
        this.keyStore = keyStore;
    }

    public void setTrustStore(TlsContextTrustStoreConfiguration trustStore) {
        this.trustStore = trustStore;
    }

    public void setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public void setEnabledCipherSuites(String enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    @Override
    public DefaultTlsContextFactory doGetObject() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory(this.getAnnotations());
        tlsContextFactory.setName(this.name);
        tlsContextFactory.setEnabledProtocols(this.enabledProtocols);
        tlsContextFactory.setEnabledCipherSuites(this.enabledCipherSuites);
        if (this.keyStore != null) {
            tlsContextFactory.setKeyAlias(this.keyStore.getAlias());
            tlsContextFactory.setKeyPassword(this.keyStore.getKeyPassword());
            if (this.keyStore.getPath() != null) {
                tlsContextFactory.setKeyStorePath(this.keyStore.getPath());
            }
            tlsContextFactory.setKeyStorePassword(this.keyStore.getPassword());
            if (this.keyStore.getType() != null) {
                tlsContextFactory.setKeyStoreType(this.keyStore.getType());
            }
            if (this.keyStore.getAlgorithm() != null) {
                tlsContextFactory.setKeyManagerAlgorithm(this.keyStore.getAlgorithm());
            }
        }
        if (this.trustStore != null) {
            if (this.trustStore.getPath() != null) {
                tlsContextFactory.setTrustStorePath(this.trustStore.getPath());
            }
            tlsContextFactory.setTrustStorePassword(this.trustStore.getPassword());
            if (this.trustStore.getType() != null) {
                tlsContextFactory.setTrustStoreType(this.trustStore.getType());
            }
            if (this.trustStore.getAlgorithm() != null) {
                tlsContextFactory.setTrustManagerAlgorithm(this.trustStore.getAlgorithm());
            }
            tlsContextFactory.setTrustStoreInsecure(this.trustStore.isInsecure());
        }
        return tlsContextFactory;
    }
}

