/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.SchedulerBusyException;

public class WaitPolicy
implements RejectedExecutionHandler {
    private final long time;
    private final TimeUnit timeUnit;
    private RejectedExecutionHandler shutdownPolicy;

    public WaitPolicy(RejectedExecutionHandler shutdownPolicy) {
        this(Long.MAX_VALUE, TimeUnit.SECONDS, shutdownPolicy);
    }

    public WaitPolicy(long time, TimeUnit timeUnit, RejectedExecutionHandler shutdownPolicy) {
        this.time = time < 0L ? Long.MAX_VALUE : time;
        this.timeUnit = timeUnit;
        this.shutdownPolicy = shutdownPolicy;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        if (e.isShutdown()) {
            this.shutdownPolicy.rejectedExecution(r, e);
        } else {
            try {
                if (!e.getQueue().offer(r, this.time, this.timeUnit)) {
                    throw new SchedulerBusyException(String.format("Scheduler did not accept within %1d %2s", new Object[]{this.time, this.timeUnit}));
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException(ie);
            }
        }
    }
}

