/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.mule.weave.v2.interpreted.InterpretedMappingExecutableWeave;
import org.mule.weave.v2.interpreted.debugger.server.DefaultWeaveDebuggingSession;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerDebuggerProtocol;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerDebuggerProtocol$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.EvaluationContext$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.runtime.CompilationResult;
import org.mule.weave.v2.runtime.ExecutableWeave;
import org.mule.weave.v2.runtime.ExecutableWeaveHelper$;
import org.mule.weave.v2.runtime.WeaveCompiler$;
import org.mule.weave.v2.runtime.utils.WeaveMappingRunner;
import org.mule.weave.v2.sdk.ParsingContextFactory$;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WeaveMappingRunner$
implements App {
    public static WeaveMappingRunner$ MODULE$;
    private OutputStream output;
    private Seq<Tuple2<String, File>> inputs;
    private boolean debug;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new WeaveMappingRunner$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public OutputStream output() {
        return this.output;
    }

    public void output_$eq(OutputStream x$1) {
        this.output = x$1;
    }

    public Seq<Tuple2<String, File>> inputs() {
        return this.inputs;
    }

    public void inputs_$eq(Seq<Tuple2<String, File>> x$1) {
        this.inputs = x$1;
    }

    public boolean debug() {
        return this.debug;
    }

    public void debug_$eq(boolean x$1) {
        this.debug = x$1;
    }

    public void main() {
        EvaluationContext ctx = EvaluationContext$.MODULE$.apply();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).isEmpty()) {
            System.err.println("Data Weave File was not specified.");
            this.usage();
        } else {
            File file = new File((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).last());
            if (!file.exists()) {
                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data Weave File does not exists ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                this.usage();
            } else {
                String[] configArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).slice(0, this.args().length - 1);
                for (int index = 0; index < configArgs.length; ++index) {
                    BoxedUnit boxedUnit;
                    String string = configArgs[index];
                    if ("-input".equals(string)) {
                        String inputName;
                        File input;
                        if (index + 2 < configArgs.length) {
                            input = new File(configArgs[index + 2]);
                            inputName = configArgs[index + 1];
                            if (!input.exists()) {
                                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input file ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputName, input.getAbsolutePath()})));
                                this.usage();
                                return;
                            }
                        } else {
                            System.err.println("Invalid amount of arguments on input.");
                            this.usage();
                            return;
                        }
                        this.inputs_$eq((Seq<Tuple2<String, File>>)((Seq)this.inputs().$colon$plus((Object)new Tuple2((Object)inputName, (Object)input), Seq$.MODULE$.canBuildFrom())));
                        index += 2;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if ("-output".equals(string)) {
                        if (index + 1 >= configArgs.length) {
                            System.err.println("Invalid amount of arguments on output.");
                            this.usage();
                            return;
                        }
                        this.output_$eq(new FileOutputStream(new File(configArgs[index + 1])));
                        ++index;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if ("-debug".equals(string)) {
                        this.debug_$eq(true);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid argument ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                    this.usage();
                    return;
                }
            }
            PhaseResult<CompilationResult<DocumentNode>> result = WeaveCompiler$.MODULE$.compile(WeaveResourceFactory$.MODULE$.fromFile(file), ParsingContextFactory$.MODULE$.createParsingContext(new NameIdentifier(file.getName(), NameIdentifier$.MODULE$.apply$default$2())));
            result.errorMessages().foreach((Function1 & Serializable & scala.Serializable)message -> {
                Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Error] ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Message)message._2()).message()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" {", ":", "}:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().line()), BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().column()), ((WeaveLocation)message._1()).locationString()}))));
                return BoxedUnit.UNIT;
            });
            result.warningMessages().foreach((Function1 & Serializable & scala.Serializable)message -> {
                Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Warning] ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Message)message._2()).message()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" {", ":", "}:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().line()), BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().column()), ((WeaveLocation)message._1()).locationString()}))));
                return BoxedUnit.UNIT;
            });
            if (result.hasErrors() || result.isEmpty()) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Errors where found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)result.errorMessages().size())})));
                return;
            }
            ExecutableWeave<DocumentNode> engine = result.getResult().executable();
            if (this.debug()) {
                CountDownLatch latch = new CountDownLatch(1);
                TcpServerDebuggerProtocol protocol = TcpServerDebuggerProtocol$.MODULE$.apply(TcpServerDebuggerProtocol$.MODULE$.apply$default$1());
                DefaultWeaveDebuggingSession debuggingSession = ((InterpretedMappingExecutableWeave)engine).debug(protocol);
                debuggingSession.addSessionListener(() -> new Thread(ctx, engine, latch, protocol){
                    private final EvaluationContext ctx$1;
                    private final ExecutableWeave engine$1;
                    private final CountDownLatch latch$1;
                    private final TcpServerDebuggerProtocol protocol$1;

                    public void run() {
                        this.engine$1.write(ExecutableWeaveHelper$.MODULE$.buildWriter(this.engine$1, WeaveMappingRunner$.MODULE$.output()), ExecutableWeaveHelper$.MODULE$.buildReaders(this.engine$1, (Map<String, Object>)WeaveMappingRunner$.MODULE$.inputs().toMap(Predef$.MODULE$.$conforms()), this.ctx$1), this.engine$1.write$default$3(), this.ctx$1);
                        this.protocol$1.disconnect();
                        this.latch$1.countDown();
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.engine$1 = engine$1;
                        this.latch$1 = latch$1;
                        this.protocol$1 = protocol$1;
                    }
                }.start());
                Predef$.MODULE$.println((Object)"Waiting for debugger client to connect.");
                latch.await();
            } else {
                engine.write(ExecutableWeaveHelper$.MODULE$.buildWriter(engine, this.output()), ExecutableWeaveHelper$.MODULE$.buildReaders(engine, (Map<String, Object>)this.inputs().toMap(Predef$.MODULE$.$conforms()), ctx), engine.write$default$3(), ctx);
            }
        }
    }

    public void usage() {
        Predef$.MODULE$.println((Object)"weave [-input <name> <value>]* [-debug]? [-output <path>]? <weave file path>");
    }

    public final void delayedEndpoint$org$mule$weave$v2$runtime$utils$WeaveMappingRunner$1() {
        this.output = System.out;
        this.inputs = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.debug = false;
        this.main();
    }

    private WeaveMappingRunner$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new WeaveMappingRunner.delayedInit.body(this));
    }
}

