/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs.opti;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.mule.apache.xerces.impl.XMLErrorReporter;
import org.mule.apache.xerces.impl.xs.SchemaSymbols;
import org.mule.apache.xerces.impl.xs.opti.DefaultXMLDocumentHandler;
import org.mule.apache.xerces.impl.xs.opti.ElementImpl;
import org.mule.apache.xerces.impl.xs.opti.SchemaConditionalIncludeHelper;
import org.mule.apache.xerces.impl.xs.opti.SchemaDOM;
import org.mule.apache.xerces.impl.xs.opti.SchemaParsingConfig;
import org.mule.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.mule.apache.xerces.util.XMLAttributesImpl;
import org.mule.apache.xerces.util.XMLChar;
import org.mule.apache.xerces.xni.Augmentations;
import org.mule.apache.xerces.xni.NamespaceContext;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xni.XMLAttributes;
import org.mule.apache.xerces.xni.XMLLocator;
import org.mule.apache.xerces.xni.XMLString;
import org.mule.apache.xerces.xni.XNIException;
import org.mule.apache.xerces.xni.parser.XMLEntityResolver;
import org.mule.apache.xerces.xni.parser.XMLInputSource;
import org.mule.apache.xerces.xni.parser.XMLParserConfiguration;
import org.mule.apache.xerces.xs.datatypes.XSDecimal;
import org.w3c.dom.Document;

public class SchemaDOMParser
extends DefaultXMLDocumentHandler {
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String GENERATE_SYNTHETIC_ANNOTATION = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected XMLLocator fLocator;
    protected NamespaceContext fNamespaceContext = null;
    SchemaDOM schemaDOM;
    XMLParserConfiguration config;
    private ElementImpl fCurrentAnnotationElement;
    private int fAnnotationDepth = -1;
    private int fInnerAnnotationDepth = -1;
    private int fDepth = -1;
    XMLErrorReporter fErrorReporter;
    private boolean fGenerateSyntheticAnnotation = false;
    private BooleanStack fHasNonSchemaAttributes = new BooleanStack();
    private BooleanStack fSawAnnotation = new BooleanStack();
    private XMLAttributes fEmptyAttr = new XMLAttributesImpl();
    private XSDecimal fSupportedVersion;
    private int fIgnoreDepth = -1;
    private boolean fPerformConditionalInclusion = true;
    private SchemaConditionalIncludeHelper schemaCondlInclHelper = new SchemaConditionalIncludeHelper();

    public SchemaDOMParser(XMLParserConfiguration config) {
        this.config = config;
        config.setDocumentHandler(this);
        config.setDTDHandler(this);
        config.setDTDContentModelHandler(this);
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.fErrorReporter = (XMLErrorReporter)this.config.getProperty(ERROR_REPORTER);
        this.fGenerateSyntheticAnnotation = this.config.getFeature(GENERATE_SYNTHETIC_ANNOTATION);
        this.fHasNonSchemaAttributes.clear();
        this.fSawAnnotation.clear();
        this.schemaDOM = new SchemaDOM();
        this.fCurrentAnnotationElement = null;
        this.fAnnotationDepth = -1;
        this.fInnerAnnotationDepth = -1;
        this.fDepth = -1;
        this.fIgnoreDepth = -1;
        this.fLocator = locator;
        this.fNamespaceContext = namespaceContext;
        this.schemaDOM.setDocumentURI(locator.getExpandedSystemId());
    }

    @Override
    public void endDocument(Augmentations augs) throws XNIException {
    }

    @Override
    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth > -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.comment(text);
        }
    }

    @Override
    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth > -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.processingInstruction(target, data);
        }
    }

    @Override
    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fIgnoreDepth > -1) {
            return;
        }
        if (this.fInnerAnnotationDepth == -1) {
            for (int i = text.offset; i < text.offset + text.length; ++i) {
                if (XMLChar.isSpace(text.ch[i])) continue;
                String txt = new String(text.ch, i, text.length + text.offset - i);
                this.fErrorReporter.reportError(this.fLocator, "http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{txt}, (short)1);
                break;
            }
        } else {
            this.schemaDOM.characters(text);
        }
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        ++this.fDepth;
        if (this.fPerformConditionalInclusion) {
            if (this.fIgnoreDepth > -1) {
                ++this.fIgnoreDepth;
                return;
            }
            if (this.fDepth > -1) {
                this.checkVersionControlAttributes(element, attributes);
                if (this.fIgnoreDepth > -1) {
                    return;
                }
            }
        }
        if (this.fAnnotationDepth == -1) {
            if (element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && element.localpart == SchemaSymbols.ELT_ANNOTATION) {
                if (this.fGenerateSyntheticAnnotation) {
                    if (this.fSawAnnotation.size() > 0) {
                        this.fSawAnnotation.pop();
                    }
                    this.fSawAnnotation.push(true);
                }
                this.fAnnotationDepth = this.fDepth;
                this.schemaDOM.startAnnotation(element, attributes, this.fNamespaceContext);
                this.fCurrentAnnotationElement = this.schemaDOM.startElement(element, attributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber(), this.fLocator.getCharacterOffset());
                return;
            }
            if (element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && this.fGenerateSyntheticAnnotation) {
                this.fSawAnnotation.push(false);
                this.fHasNonSchemaAttributes.push(this.hasNonSchemaAttributes(element, attributes));
            }
        } else if (this.fDepth == this.fAnnotationDepth + 1) {
            this.fInnerAnnotationDepth = this.fDepth;
            this.schemaDOM.startAnnotationElement(element, attributes);
        } else {
            this.schemaDOM.startAnnotationElement(element, attributes);
            return;
        }
        this.schemaDOM.startElement(element, attributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber(), this.fLocator.getCharacterOffset());
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.fPerformConditionalInclusion) {
            if (this.fIgnoreDepth > -1) {
                return;
            }
            if (this.fDepth > -1) {
                boolean vcExclude = this.checkVersionControlAttributes(element, attributes);
                if (this.fIgnoreDepth > -1) {
                    if (vcExclude) {
                        --this.fIgnoreDepth;
                    }
                    return;
                }
            }
        }
        if (this.fGenerateSyntheticAnnotation && this.fAnnotationDepth == -1 && element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && element.localpart != SchemaSymbols.ELT_ANNOTATION && this.hasNonSchemaAttributes(element, attributes)) {
            this.schemaDOM.startElement(element, attributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber(), this.fLocator.getCharacterOffset());
            attributes.removeAllAttributes();
            String schemaPrefix = this.fNamespaceContext.getPrefix(SchemaSymbols.URI_SCHEMAFORSCHEMA);
            String annRawName = schemaPrefix.length() == 0 ? SchemaSymbols.ELT_ANNOTATION : schemaPrefix + ':' + SchemaSymbols.ELT_ANNOTATION;
            this.schemaDOM.startAnnotation(annRawName, attributes, this.fNamespaceContext);
            String elemRawName = schemaPrefix.length() == 0 ? SchemaSymbols.ELT_DOCUMENTATION : schemaPrefix + ':' + SchemaSymbols.ELT_DOCUMENTATION;
            this.schemaDOM.startAnnotationElement(elemRawName, attributes);
            this.schemaDOM.charactersRaw("SYNTHETIC_ANNOTATION");
            this.schemaDOM.endSyntheticAnnotationElement(elemRawName, false);
            this.schemaDOM.endSyntheticAnnotationElement(annRawName, true);
            this.schemaDOM.endElement();
            return;
        }
        if (this.fAnnotationDepth == -1) {
            if (element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && element.localpart == SchemaSymbols.ELT_ANNOTATION) {
                this.schemaDOM.startAnnotation(element, attributes, this.fNamespaceContext);
            }
        } else {
            this.schemaDOM.startAnnotationElement(element, attributes);
        }
        ElementImpl newElem = this.schemaDOM.emptyElement(element, attributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber(), this.fLocator.getCharacterOffset());
        if (this.fAnnotationDepth == -1) {
            if (element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && element.localpart == SchemaSymbols.ELT_ANNOTATION) {
                this.schemaDOM.endAnnotation(element, newElem);
            }
        } else {
            this.schemaDOM.endAnnotationElement(element);
        }
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.fIgnoreDepth == -1) {
            if (this.fAnnotationDepth > -1) {
                if (this.fInnerAnnotationDepth == this.fDepth) {
                    this.fInnerAnnotationDepth = -1;
                    this.schemaDOM.endAnnotationElement(element);
                    this.schemaDOM.endElement();
                } else if (this.fAnnotationDepth == this.fDepth) {
                    this.fAnnotationDepth = -1;
                    this.schemaDOM.endAnnotation(element, this.fCurrentAnnotationElement);
                    this.schemaDOM.endElement();
                } else {
                    this.schemaDOM.endAnnotationElement(element);
                }
            } else {
                if (element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && this.fGenerateSyntheticAnnotation) {
                    boolean value = this.fHasNonSchemaAttributes.pop();
                    boolean sawann = this.fSawAnnotation.pop();
                    if (value && !sawann) {
                        String schemaPrefix = this.fNamespaceContext.getPrefix(SchemaSymbols.URI_SCHEMAFORSCHEMA);
                        String annRawName = schemaPrefix.length() == 0 ? SchemaSymbols.ELT_ANNOTATION : schemaPrefix + ':' + SchemaSymbols.ELT_ANNOTATION;
                        this.schemaDOM.startAnnotation(annRawName, this.fEmptyAttr, this.fNamespaceContext);
                        String elemRawName = schemaPrefix.length() == 0 ? SchemaSymbols.ELT_DOCUMENTATION : schemaPrefix + ':' + SchemaSymbols.ELT_DOCUMENTATION;
                        this.schemaDOM.startAnnotationElement(elemRawName, this.fEmptyAttr);
                        this.schemaDOM.charactersRaw("SYNTHETIC_ANNOTATION");
                        this.schemaDOM.endSyntheticAnnotationElement(elemRawName, false);
                        this.schemaDOM.endSyntheticAnnotationElement(annRawName, true);
                    }
                }
                this.schemaDOM.endElement();
            }
        } else {
            --this.fIgnoreDepth;
        }
        --this.fDepth;
    }

    private boolean hasNonSchemaAttributes(QName element, XMLAttributes attributes) {
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String uri = attributes.getURI(i);
            if (uri == null || uri == SchemaSymbols.URI_SCHEMAFORSCHEMA || uri == NamespaceContext.XMLNS_URI || uri == NamespaceContext.XML_URI && attributes.getQName(i) == SchemaSymbols.ATT_XML_LANG && element.localpart == SchemaSymbols.ELT_SCHEMA) continue;
            return true;
        }
        return false;
    }

    @Override
    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth != -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.characters(text);
        }
    }

    @Override
    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth != -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.startAnnotationCDATA();
        }
    }

    @Override
    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth != -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.endAnnotationCDATA();
        }
    }

    public Document getDocument() {
        return this.schemaDOM;
    }

    public void setFeature(String featureId, boolean state) {
        this.config.setFeature(featureId, state);
    }

    public boolean getFeature(String featureId) {
        return this.config.getFeature(featureId);
    }

    public void setProperty(String propertyId, Object value) {
        this.config.setProperty(propertyId, value);
    }

    public Object getProperty(String propertyId) {
        return this.config.getProperty(propertyId);
    }

    public void setEntityResolver(XMLEntityResolver er) {
        this.config.setEntityResolver(er);
    }

    public void parse(XMLInputSource inputSource) throws IOException {
        this.config.parse(inputSource);
    }

    public void reset() {
        ((SchemaParsingConfig)this.config).reset();
    }

    public void resetNodePool() {
        ((SchemaParsingConfig)this.config).resetNodePool();
    }

    public void setSupportedVersion(XSDecimal version) {
        this.fSupportedVersion = version;
    }

    private boolean checkVersionControlAttributes(QName element, XMLAttributes attributes) {
        boolean isIgnoreSchemaComponent = false;
        BigDecimal minVer = null;
        BigDecimal maxVer = null;
        List typeAvailableList = null;
        List typeUnavailableList = null;
        List facetAvailableList = null;
        List facetUnavailableList = null;
        for (int attrIdx = 0; attrIdx < attributes.getLength(); ++attrIdx) {
            if (!SchemaSymbols.URI_SCHEMAVERSION.equals(attributes.getURI(attrIdx))) continue;
            String attrLocalName = attributes.getLocalName(attrIdx);
            String attrValue = attributes.getValue(attrIdx);
            if (SchemaSymbols.ATT_MINVERSION.equals(attrLocalName)) {
                try {
                    minVer = new BigDecimal(attrValue);
                }
                catch (NumberFormatException nfe) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-att-invalid-value", new Object[]{element.localpart, attrLocalName, nfe.getMessage()}, (short)1);
                }
                continue;
            }
            if (SchemaSymbols.ATT_MAXVERSION.equals(attrLocalName)) {
                try {
                    maxVer = new BigDecimal(attrValue);
                }
                catch (NumberFormatException nfe) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-att-invalid-value", new Object[]{element.localpart, attrLocalName, nfe.getMessage()}, (short)1);
                }
                continue;
            }
            if (SchemaSymbols.ATT_TYPEAVAILABLE.equals(attrLocalName)) {
                typeAvailableList = this.tokenizeQNameListString(attrValue);
                continue;
            }
            if (SchemaSymbols.ATT_TYPEUNAVAILABLE.equals(attrLocalName)) {
                typeUnavailableList = this.tokenizeQNameListString(attrValue);
                continue;
            }
            if (SchemaSymbols.ATT_FACETAVAILABLE.equals(attrLocalName)) {
                facetAvailableList = this.tokenizeQNameListString(attrValue);
                continue;
            }
            if (SchemaSymbols.ATT_FACETUNAVAILABLE.equals(attrLocalName)) {
                facetUnavailableList = this.tokenizeQNameListString(attrValue);
                continue;
            }
            this.fErrorReporter.reportError(this.fLocator, "http://www.w3.org/TR/xml-schema-1", "src-cip.1", new Object[]{attrLocalName}, (short)0);
        }
        boolean minMaxSchemaVerAllowsIgnore = minVer == null && maxVer == null ? false : this.isSchemaLangVersionAllowsExclude(minVer, maxVer);
        boolean typeAvlAllowsIgnore = typeAvailableList == null ? false : this.isTypeAndFacetAvailableAllowsExclude(typeAvailableList, (short)0, (short)2);
        boolean typeUnavlAllowsIgnore = typeUnavailableList == null ? false : this.isTypeAndFacetAvailableAllowsExclude(typeUnavailableList, (short)0, (short)3);
        boolean facetAvlAllowsIgnore = facetAvailableList == null ? false : this.isTypeAndFacetAvailableAllowsExclude(facetAvailableList, (short)1, (short)2);
        boolean facetUnavlAllowsIgnore = facetUnavailableList == null ? false : this.isTypeAndFacetAvailableAllowsExclude(facetUnavailableList, (short)1, (short)3);
        isIgnoreSchemaComponent = minMaxSchemaVerAllowsIgnore || typeAvlAllowsIgnore || typeUnavlAllowsIgnore || facetAvlAllowsIgnore || facetUnavlAllowsIgnore;
        return isIgnoreSchemaComponent;
    }

    private boolean isSchemaLangVersionAllowsExclude(BigDecimal minVer, BigDecimal maxVer) {
        boolean minMaxSchemaVerAllowsIgnore = false;
        if (minVer != null && maxVer != null) {
            if (minVer.compareTo(this.fSupportedVersion.getBigDecimal()) > 0 || maxVer.compareTo(this.fSupportedVersion.getBigDecimal()) != 1) {
                ++this.fIgnoreDepth;
                minMaxSchemaVerAllowsIgnore = true;
            }
        } else if (minVer != null && maxVer == null) {
            if (minVer.compareTo(this.fSupportedVersion.getBigDecimal()) > 0) {
                ++this.fIgnoreDepth;
                minMaxSchemaVerAllowsIgnore = true;
            }
        } else if (minVer == null && maxVer != null && maxVer.compareTo(this.fSupportedVersion.getBigDecimal()) != 1) {
            ++this.fIgnoreDepth;
            minMaxSchemaVerAllowsIgnore = true;
        }
        return minMaxSchemaVerAllowsIgnore;
    }

    private boolean isTypeAndFacetAvailableAllowsExclude(List typeOrFacetList, short typeOrFacet, short availaibilityUnavlCheck) {
        boolean typeOrFacetAvlAllowsIgnore = false;
        boolean typeOrFacetUnavlAllowsIgnore = true;
        for (String typeOrFacetRawValue : typeOrFacetList) {
            String typeOrFacetLocalName = null;
            String typeOrFacetUri = null;
            if (typeOrFacetRawValue.indexOf(58) != -1) {
                typeOrFacetLocalName = typeOrFacetRawValue.substring(typeOrFacetRawValue.indexOf(58) + 1);
                String typeOrFacetPrefix = typeOrFacetRawValue.substring(0, typeOrFacetRawValue.indexOf(58));
                typeOrFacetUri = this.fNamespaceContext.getURI(typeOrFacetPrefix.intern());
            } else {
                typeOrFacetLocalName = typeOrFacetRawValue;
            }
            if (typeOrFacet == 0) {
                if (availaibilityUnavlCheck == 2 && !this.schemaCondlInclHelper.isTypeSupported(typeOrFacetLocalName, typeOrFacetUri)) {
                    typeOrFacetAvlAllowsIgnore = true;
                    break;
                }
                if (availaibilityUnavlCheck != 3 || this.schemaCondlInclHelper.isTypeSupported(typeOrFacetLocalName, typeOrFacetUri)) continue;
                typeOrFacetUnavlAllowsIgnore = false;
                break;
            }
            if (typeOrFacet != 1) continue;
            if (availaibilityUnavlCheck == 2 && !this.schemaCondlInclHelper.isFacetSupported(typeOrFacetLocalName, typeOrFacetUri)) {
                typeOrFacetAvlAllowsIgnore = true;
                break;
            }
            if (availaibilityUnavlCheck != 3 || this.schemaCondlInclHelper.isFacetSupported(typeOrFacetLocalName, typeOrFacetUri)) continue;
            typeOrFacetUnavlAllowsIgnore = false;
            break;
        }
        if (availaibilityUnavlCheck == 2) {
            if (typeOrFacetAvlAllowsIgnore) {
                ++this.fIgnoreDepth;
            }
            return typeOrFacetAvlAllowsIgnore;
        }
        if (typeOrFacetUnavlAllowsIgnore) {
            ++this.fIgnoreDepth;
        }
        return typeOrFacetUnavlAllowsIgnore;
    }

    private List tokenizeQNameListString(String strValue) {
        StringTokenizer st = new StringTokenizer(strValue, " \n\t\r");
        ArrayList<String> stringTokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String QNameStr = st.nextToken();
            XS11TypeHelper.validateQNameValue(QNameStr, this.fNamespaceContext, this.fErrorReporter);
            stringTokens.add(QNameStr);
        }
        return stringTokens;
    }

    private static final class BooleanStack {
        private int fDepth;
        private boolean[] fData;

        public int size() {
            return this.fDepth;
        }

        public void push(boolean value) {
            this.ensureCapacity(this.fDepth + 1);
            this.fData[this.fDepth++] = value;
        }

        public boolean pop() {
            return this.fData[--this.fDepth];
        }

        public void clear() {
            this.fDepth = 0;
        }

        private void ensureCapacity(int size) {
            if (this.fData == null) {
                this.fData = new boolean[32];
            } else if (this.fData.length <= size) {
                boolean[] newdata = new boolean[this.fData.length * 2];
                System.arraycopy(this.fData, 0, newdata, 0, this.fData.length);
                this.fData = newdata;
            }
        }
    }
}

