/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.internal.util.StringByteSizeCalculator;

public final class TypedValue<T>
implements Serializable {
    private static final long serialVersionUID = -2533879516750283994L;
    private final T value;
    private final DataType dataType;
    private final long length;

    public static <T> T unwrap(Object value) {
        if (value instanceof TypedValue) {
            return ((TypedValue)value).getValue();
        }
        return (T)value;
    }

    public static <T> TypedValue<T> of(T value) {
        if (value instanceof TypedValue) {
            return (TypedValue)value;
        }
        return new TypedValue<T>(value, DataType.fromObject(value));
    }

    public TypedValue(T value, DataType dataType) {
        this(value, dataType, Optional.empty());
    }

    public TypedValue(T value, DataType dataType, Optional<Long> length) {
        this.value = value;
        this.dataType = dataType == null ? DataType.fromObject(value) : dataType;
        if (length.isPresent()) {
            this.length = length.get();
        } else if (value instanceof byte[]) {
            this.length = ((byte[])value).length;
        } else if (value instanceof String) {
            StringByteSizeCalculator stringByteSizeCalculator = new StringByteSizeCalculator();
            Charset charset = this.dataType.getMediaType().getCharset().orElse(Charset.defaultCharset());
            this.length = stringByteSizeCalculator.count((String)value, charset);
        } else {
            this.length = -1L;
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public T getValue() {
        return this.value;
    }

    public Optional<Long> getLength() {
        return this.length >= 0L ? Optional.of(this.length) : Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedValue that = (TypedValue)o;
        if (this.length != that.length) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        return result;
    }
}

