/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.AsyncMessageNotificationListener;
import org.mule.runtime.api.notification.ClusterNodeNotification;
import org.mule.runtime.api.notification.ClusterNodeNotificationListener;
import org.mule.runtime.api.notification.ConnectionNotification;
import org.mule.runtime.api.notification.ConnectionNotificationListener;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.ConnectorMessageNotificationListener;
import org.mule.runtime.api.notification.CustomNotification;
import org.mule.runtime.api.notification.CustomNotificationListener;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.api.notification.ErrorHandlerNotificationListener;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.ExceptionNotificationListener;
import org.mule.runtime.api.notification.ExtensionNotification;
import org.mule.runtime.api.notification.ExtensionNotificationListener;
import org.mule.runtime.api.notification.FlowConstructNotification;
import org.mule.runtime.api.notification.FlowConstructNotificationListener;
import org.mule.runtime.api.notification.ManagementNotification;
import org.mule.runtime.api.notification.ManagementNotificationListener;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.PipelineMessageNotificationListener;
import org.mule.runtime.api.notification.RoutingNotification;
import org.mule.runtime.api.notification.RoutingNotificationListener;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.notification.SecurityNotificationListener;
import org.mule.runtime.api.notification.TransactionNotification;
import org.mule.runtime.api.notification.TransactionNotificationListener;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.NotifierCallback;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.notification.Configuration;
import org.mule.runtime.core.internal.context.notification.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerNotificationManager
implements ServerNotificationHandler,
MuleContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ServerNotificationManager.class);
    private boolean dynamic = false;
    private Configuration configuration = new Configuration();
    private AtomicInteger activeFires = new AtomicInteger();
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private Latch disposeLatch = new Latch();
    private MuleContext muleContext;
    private Scheduler notificationsLiteScheduler;
    private Scheduler notificationsIoScheduler;

    @Override
    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setNotificationDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void initialise() throws InitialisationException {
        this.notificationsLiteScheduler = this.muleContext.getSchedulerService().cpuLightScheduler();
        this.notificationsIoScheduler = this.muleContext.getSchedulerService().ioScheduler();
    }

    public void addInterfaceToType(Class<? extends NotificationListener> iface, Class<? extends Notification> event) {
        this.configuration.addInterfaceToType(iface, event);
    }

    public void setInterfaceToTypes(Map<Class<? extends NotificationListener>, Set<Class<? extends Notification>>> interfaceToEvents) throws ClassNotFoundException {
        this.configuration.addAllInterfaceToTypes(interfaceToEvents);
    }

    public void addListenerSubscriptionPair(ListenerSubscriptionPair pair) {
        this.configuration.addListenerSubscriptionPair(pair);
    }

    public void addListener(NotificationListener<?> listener) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener));
    }

    public <N extends Notification> void addListenerSubscription(NotificationListener<N> listener, Predicate<N> selector) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair<N>(listener, selector));
    }

    public void removeListener(NotificationListener<?> listener) {
        this.configuration.removeListener(listener);
    }

    public void disableInterface(Class<? extends NotificationListener> iface) {
        this.configuration.disableInterface(iface);
    }

    public void setDisabledInterfaces(Collection<Class<? extends NotificationListener>> interfaces) throws ClassNotFoundException {
        this.configuration.disabledAllInterfaces(interfaces);
    }

    public void disableType(Class<? extends Notification> type) {
        this.configuration.disableType(type);
    }

    @Override
    public boolean isListenerRegistered(NotificationListener listener) {
        for (ListenerSubscriptionPair pair : this.configuration.getListeners()) {
            if (!pair.getListener().equals(listener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fireNotification(Notification notification) {
        if (this.disposed.get()) {
            logger.warn("Notification not enqueued after ServerNotificationManager disposal: " + notification);
            return;
        }
        this.activeFires.incrementAndGet();
        try {
            if (notification instanceof AbstractServerNotification) {
                ((AbstractServerNotification)notification).setServerId(this.muleContext.getId());
            }
            if (notification.isSynchronous()) {
                this.notifyListeners(notification, (listener, nfn) -> listener.onNotification(nfn));
            } else {
                this.notifyListeners(notification, (listener, nfn) -> {
                    if (listener.isBlocking()) {
                        this.notificationsIoScheduler.submit(() -> listener.onNotification(nfn));
                    } else {
                        this.notificationsLiteScheduler.submit(() -> listener.onNotification(nfn));
                    }
                });
            }
        }
        finally {
            if (0 == this.activeFires.decrementAndGet() && this.disposed.get()) {
                this.disposeLatch.countDown();
            }
        }
    }

    protected void notifyListeners(Notification notification, NotifierCallback notifier) {
        this.configuration.getPolicy().dispatch(notification, notifier);
    }

    @Override
    public boolean isNotificationEnabled(Class<? extends Notification> type) {
        Policy policy;
        boolean enabled = false;
        if (this.configuration != null && (policy = this.configuration.getPolicy()) != null) {
            enabled = policy.isNotificationEnabled(type);
        }
        return enabled;
    }

    public void dispose() {
        this.disposed.set(true);
        if (this.activeFires.get() > 0) {
            try {
                this.disposeLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.notificationsLiteScheduler != null) {
            this.notificationsLiteScheduler.stop();
            this.notificationsLiteScheduler = null;
        }
        if (this.notificationsIoScheduler != null) {
            this.notificationsIoScheduler.stop();
            this.notificationsIoScheduler = null;
        }
        this.configuration = null;
    }

    public static Class toClass(Object value) throws ClassNotFoundException {
        Class clazz;
        if (value instanceof String) {
            clazz = ClassUtils.loadClass(value.toString(), value.getClass());
        } else if (value instanceof Class) {
            clazz = (Class)value;
        } else {
            throw new IllegalArgumentException("Notification types and listeners must be a Class with fully qualified class name. Value is: " + value);
        }
        return clazz;
    }

    Policy getPolicy() {
        return this.configuration.getPolicy();
    }

    public Map<Class<? extends NotificationListener>, Set<Class<? extends Notification>>> getInterfaceToTypes() {
        return Collections.unmodifiableMap(this.configuration.getInterfaceToTypes());
    }

    public Set<ListenerSubscriptionPair> getListeners() {
        return Collections.unmodifiableSet(this.configuration.getListeners());
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public static ServerNotificationManager createDefaultNotificationManager() {
        ServerNotificationManager manager = new ServerNotificationManager();
        manager.addInterfaceToType(MuleContextNotificationListener.class, MuleContextNotification.class);
        manager.addInterfaceToType(RoutingNotificationListener.class, RoutingNotification.class);
        manager.addInterfaceToType(SecurityNotificationListener.class, SecurityNotification.class);
        manager.addInterfaceToType(ManagementNotificationListener.class, ManagementNotification.class);
        manager.addInterfaceToType(CustomNotificationListener.class, CustomNotification.class);
        manager.addInterfaceToType(ConnectionNotificationListener.class, ConnectionNotification.class);
        manager.addInterfaceToType(ExceptionNotificationListener.class, ExceptionNotification.class);
        manager.addInterfaceToType(ErrorHandlerNotificationListener.class, ErrorHandlerNotification.class);
        manager.addInterfaceToType(TransactionNotificationListener.class, TransactionNotification.class);
        manager.addInterfaceToType(PipelineMessageNotificationListener.class, PipelineMessageNotification.class);
        manager.addInterfaceToType(AsyncMessageNotificationListener.class, AsyncMessageNotification.class);
        manager.addInterfaceToType(ClusterNodeNotificationListener.class, ClusterNodeNotification.class);
        manager.addInterfaceToType(ConnectorMessageNotificationListener.class, ConnectorMessageNotification.class);
        manager.addInterfaceToType(ErrorHandlerNotificationListener.class, ErrorHandlerNotification.class);
        manager.addInterfaceToType(FlowConstructNotificationListener.class, FlowConstructNotification.class);
        manager.addInterfaceToType(ExtensionNotificationListener.class, ExtensionNotification.class);
        return manager;
    }
}

