/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PolicyChain
extends AbstractComponent
implements Initialisable,
Startable,
Stoppable,
Disposable,
Processor {
    @Inject
    private MuleContext muleContext;
    private ProcessingStrategy processingStrategy;
    private List<Processor> processors;
    private MessageProcessorChain processorChain;
    private ReactiveProcessor chainWithMPs;
    private PolicyNotificationHelper notificationHelper;
    private boolean propagateMessageTransformations;

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    @Override
    public final void initialise() throws InitialisationException {
        this.processorChain = MessageProcessors.newChain(Optional.of(this.processingStrategy), this.processors);
        this.chainWithMPs = this.processingStrategy.onPipeline(this.processorChain);
        LifecycleUtils.initialiseIfNeeded(this.processorChain, this.muleContext);
        this.notificationHelper = new PolicyNotificationHelper(this.muleContext.getNotificationManager(), this.muleContext.getConfiguration().getId(), this);
    }

    public void setProcessingStrategy(ProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    @Override
    public void start() throws MuleException {
        if (this.processorChain != null) {
            this.processorChain.start();
        }
    }

    @Override
    public void dispose() {
        if (this.processorChain != null) {
            this.processorChain.dispose();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.processorChain != null) {
            this.processorChain.stop();
        }
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this.chainWithMPs);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Mono.from(publisher).doOnNext(this.pushBeforeNextFlowStackElement().andThen((? super T req) -> ((BaseEventContext)req.getContext()).onResponse(this.notificationHelper.successOrErrorNotification(2104).andThen((? super T resp, ? super U t) -> this.popFlowFlowStackElement().accept((CoreEvent)req)))).andThen(this.notificationHelper.notification(2101))).transform((Function)this.chainWithMPs);
    }

    private Consumer<CoreEvent> pushBeforeNextFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.getLocation().getLocation() + "[before next]", null));
    }

    private Consumer<CoreEvent> popFlowFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
    }

    public boolean isPropagateMessageTransformations() {
        return this.propagateMessageTransformations;
    }

    public void setPropagateMessageTransformations(boolean propagateMessageTransformations) {
        this.propagateMessageTransformations = propagateMessageTransformations;
    }
}

