/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.security;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.mule.runtime.core.api.security.SecurityManager;

public class DefaultMuleCredentials
implements Credentials,
Serializable {
    private static final String TOKEN_DELIM = "::";
    private static final long serialVersionUID = 6841073031207301664L;
    private final String username;
    private final char[] password;
    private Object roles;

    public DefaultMuleCredentials(String username, char[] password) {
        this.username = username;
        this.password = ArrayUtils.clone((char[])password);
    }

    public DefaultMuleCredentials(String username, char[] password, Object roles) {
        this.username = username;
        this.password = ArrayUtils.clone((char[])password);
        this.roles = roles;
    }

    public DefaultMuleCredentials(String header, SecurityManager sm) throws EncryptionStrategyNotFoundException, CryptoFailureException {
        int i = header.indexOf(32);
        if (i == -1) {
            throw new IllegalArgumentException(I18nMessageFactory.createStaticMessage("Header field 'MULE_USER' is malformed. Value is '%s'", header).toString());
        }
        String scheme = header.substring(0, i);
        String creds = header.substring(i + 1);
        if (!scheme.equalsIgnoreCase("plain")) {
            EncryptionStrategy es = sm.getEncryptionStrategy(scheme);
            if (es == null) {
                throw new EncryptionStrategyNotFoundException(scheme);
            }
            creds = new String(es.decrypt(creds.getBytes(), null));
        }
        StringTokenizer st = new StringTokenizer(creds, TOKEN_DELIM);
        this.username = st.nextToken();
        this.password = st.nextToken().toCharArray();
        if (st.hasMoreTokens()) {
            this.roles = st.nextToken();
        }
    }

    public String getToken() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.username).append(TOKEN_DELIM);
        buf.append(this.password).append(TOKEN_DELIM);
        if (this.roles != null) {
            buf.append(this.roles);
        }
        return buf.toString();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public char[] getPassword() {
        return ArrayUtils.clone((char[])this.password);
    }

    @Override
    public Object getRoles() {
        return this.roles;
    }

    public static String createHeader(String username, char[] password) {
        StringBuilder buf = new StringBuilder(32);
        buf.append("Plain ");
        buf.append(username).append(TOKEN_DELIM);
        buf.append(password).append(TOKEN_DELIM);
        return buf.toString();
    }

    public static String createHeader(String username, String password, String encryptionName, EncryptionStrategy es) throws CryptoFailureException {
        StringBuilder buf = new StringBuilder();
        buf.append(encryptionName).append(" ");
        String creds = username + TOKEN_DELIM + password;
        byte[] encrypted = es.encrypt(creds.getBytes(), null);
        buf.append(new String(encrypted));
        return buf.toString();
    }
}

