/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;

public class FunctionalReadWriteLock {
    private ReadWriteLock readWriteLock;
    private Lock readLock;
    private Lock writeLock;

    public static FunctionalReadWriteLock readWriteLock() {
        FunctionalReadWriteLock lock = new FunctionalReadWriteLock();
        lock.readWriteLock = new ReentrantReadWriteLock();
        lock.readLock = lock.readWriteLock.readLock();
        lock.writeLock = lock.readWriteLock.writeLock();
        return lock;
    }

    private FunctionalReadWriteLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withReadLock(CheckedFunction<LockReleaser, T> function) {
        DefaultLockReleaser releaser = new DefaultLockReleaser(this.readLock);
        this.readLock.lock();
        try {
            T t = function.apply(releaser);
            return t;
        }
        finally {
            releaser.release();
        }
    }

    public <T> T withWriteLock(CheckedSupplier<T> supplier) {
        return ConcurrencyUtils.withLock(this.writeLock, supplier);
    }

    public void withWriteLock(CheckedRunnable runnable) {
        ConcurrencyUtils.withLock(this.writeLock, runnable);
    }

    private final class DefaultLockReleaser
    implements LockReleaser {
        private final Lock lock;
        private boolean acquired = true;

        private DefaultLockReleaser(Lock lock) {
            this.lock = lock;
        }

        @Override
        public void release() {
            if (this.acquired) {
                try {
                    this.lock.unlock();
                }
                finally {
                    this.acquired = false;
                }
            }
        }
    }

    @FunctionalInterface
    public static interface LockReleaser {
        public void release();
    }
}

