/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.xmlsecurity;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.mule.runtime.core.internal.util.xmlsecurity.DefaultXMLSecureFactories;
import org.mule.runtime.core.internal.util.xmlsecurity.XMLSecureFactoriesCache;

public class XMLSecureFactories {
    public static final String EXTERNAL_ENTITIES_PROPERTY = "mule.xml.expandExternalEntities";
    public static final String EXPAND_ENTITIES_PROPERTY = "mule.xml.expandInternalEntities";
    private Boolean externalEntities;
    private Boolean expandEntities;
    private DefaultXMLSecureFactories secureFactories;

    public static XMLSecureFactories createWithConfig(Boolean externalEntities, Boolean expandEntities) {
        return new XMLSecureFactories(externalEntities, expandEntities);
    }

    public static XMLSecureFactories createDefault() {
        return new XMLSecureFactories();
    }

    private XMLSecureFactories() {
        String externalEntitiesValue = System.getProperty(EXTERNAL_ENTITIES_PROPERTY, "false");
        this.externalEntities = Boolean.parseBoolean(externalEntitiesValue);
        String expandEntitiesValue = System.getProperty(EXPAND_ENTITIES_PROPERTY, "false");
        this.expandEntities = Boolean.parseBoolean(expandEntitiesValue);
        this.secureFactories = new DefaultXMLSecureFactories(this.externalEntities, this.expandEntities);
    }

    private XMLSecureFactories(Boolean externalEntities, Boolean expandEntities) {
        this.externalEntities = externalEntities;
        this.expandEntities = expandEntities;
        this.secureFactories = new DefaultXMLSecureFactories(externalEntities, expandEntities);
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return XMLSecureFactoriesCache.getInstance().getDocumentBuilderFactory(this.secureFactories);
    }

    public SAXParserFactory getSAXParserFactory() {
        return XMLSecureFactoriesCache.getInstance().getSAXParserFactory(this.secureFactories);
    }

    public XMLInputFactory getXMLInputFactory() {
        return XMLSecureFactoriesCache.getInstance().getXMLInputFactory(this.secureFactories);
    }

    public TransformerFactory getTransformerFactory() {
        return XMLSecureFactoriesCache.getInstance().getTransformerFactory(this.secureFactories);
    }

    public SchemaFactory getSchemaFactory(String schemaLocation) {
        return XMLSecureFactoriesCache.getInstance().getSchemaFactory(this.secureFactories, schemaLocation);
    }

    public void configureXMLInputFactory(XMLInputFactory factory) {
        this.secureFactories.configureXMLInputFactory(factory);
    }

    public void configureTransformerFactory(TransformerFactory factory) {
        this.secureFactories.configureTransformerFactory(factory);
    }

    public void configureValidator(Validator validator) {
        this.secureFactories.configureValidator(validator);
    }
}

