/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.dataweave;

import java.util.Iterator;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.context.MuleInstanceContext;
import org.mule.runtime.core.internal.el.context.ServerContext;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveArtifactContext;

public class DataWeaveExpressionLanguageAdaptor
implements ExtendedExpressionLanguageAdaptor {
    public static final String SERVER = "server";
    public static final String MULE = "mule";
    public static final String APP = "app";
    private ExpressionLanguage expressionExecutor;
    private MuleContext muleContext;

    public static DataWeaveExpressionLanguageAdaptor create(MuleContext muleContext, Registry registry) {
        return new DataWeaveExpressionLanguageAdaptor(muleContext, registry, registry.lookupByType(DefaultExpressionLanguageFactoryService.class).get());
    }

    @Inject
    public DataWeaveExpressionLanguageAdaptor(MuleContext muleContext, Registry registry, DefaultExpressionLanguageFactoryService service) {
        this.expressionExecutor = service.create();
        this.muleContext = muleContext;
        this.registerGlobalBindings(registry);
    }

    private void registerGlobalBindings(Registry registry) {
        BindingContext.Builder contextBuilder = BindingContext.builder();
        contextBuilder.addBinding(MULE, new TypedValue<MuleInstanceContext>(new MuleInstanceContext(this.muleContext), DataType.fromType(MuleInstanceContext.class)));
        contextBuilder.addBinding(SERVER, new TypedValue<ServerContext>(new ServerContext(), DataType.fromType(ServerContext.class)));
        contextBuilder.addBinding(APP, new TypedValue<DataWeaveArtifactContext>(new DataWeaveArtifactContext(this.muleContext, registry), DataType.fromType(DataWeaveArtifactContext.class)));
        this.addGlobalBindings(contextBuilder.build());
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionExecutor.addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, BindingContext context) {
        String sanitized = this.sanitize(expression);
        if (this.isPayloadExpression(sanitized)) {
            return event.getMessage().getPayload();
        }
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(null, event, context);
        return this.evaluate(sanitized, exp -> this.expressionExecutor.evaluate((String)exp, contextBuilder.build()));
    }

    private boolean isPayloadExpression(String sanitized) {
        return sanitized.equals("payload");
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, BindingContext context) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(null, event, context);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.evaluate((String)exp, expectedOutputType, contextBuilder.build()));
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, ComponentLocation componentLocation, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(componentLocation, event, context);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.evaluate((String)exp, expectedOutputType, contextBuilder.build()));
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) {
        return this.evaluate(expression, event, null, componentLocation, bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext context) {
        String sanitized = this.sanitize(expression);
        if (this.isPayloadExpression(sanitized)) {
            return event != null ? event.getMessage().getPayload() : (context != null ? (TypedValue)context.lookup("payload").orElse(null) : null);
        }
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(componentLocation, event, context);
        return this.evaluate(sanitized, exp -> this.expressionExecutor.evaluate((String)exp, contextBuilder.build()));
    }

    @Override
    public TypedValue<?> evaluateLogExpression(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.expressionExecutor.evaluateLogExpression(this.sanitize(expression), this.bindingContextBuilderFor(componentLocation, event, bindingContext).build());
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.expressionExecutor.validate(this.sanitize(expression));
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(componentLocation, event, bindingContext);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.split((String)exp, contextBuilder.build()));
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(null, event, bindingContext);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.split((String)exp, contextBuilder.build()));
    }

    @Override
    public void enrich(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, Object object) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    @Override
    public void enrich(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, TypedValue value) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    private <T> T sanitizeAndEvaluate(String expression, Function<String, T> evaluation) {
        return this.evaluate(this.sanitize(expression), evaluation);
    }

    private <T> T evaluate(String expression, Function<String, T> evaluation) {
        try {
            return evaluation.apply(expression);
        }
        catch (ExpressionExecutionException e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), (Throwable)e);
        }
    }

    private BindingContext.Builder bindingContextBuilderFor(ComponentLocation componentLocation, CoreEvent event, BindingContext context) {
        BindingContext.Builder contextBuilder = event != null ? BindingContextUtils.addEventBuindingsToBuilder(event, context) : BindingContext.builder(context);
        if (componentLocation != null) {
            contextBuilder.addBinding("flow", () -> new TypedValue<FlowVariablesAccessor>(new FlowVariablesAccessor(componentLocation.getRootContainerName()), DataType.fromType(FlowVariablesAccessor.class)));
        }
        return contextBuilder;
    }

    private String sanitize(String expression) {
        String sanitizedExpression;
        if (expression.startsWith("#[")) {
            if (!expression.endsWith("]")) {
                throw new ExpressionExecutionException(I18nMessageFactory.createStaticMessage(String.format("Unbalanced brackets in expression '%s'", expression)));
            }
            sanitizedExpression = expression.substring("#[".length(), expression.length() - "]".length());
        } else {
            sanitizedExpression = expression;
        }
        if (sanitizedExpression.startsWith("dw:") && !sanitizedExpression.substring(DefaultExpressionManager.DW_PREFIX_LENGTH, DefaultExpressionManager.DW_PREFIX_LENGTH + 1).equals(":")) {
            sanitizedExpression = sanitizedExpression.substring(DefaultExpressionManager.DW_PREFIX_LENGTH);
        }
        return sanitizedExpression;
    }

    private class FlowVariablesAccessor {
        private String name;

        public FlowVariablesAccessor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

