/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.internal.management.stats.DefaultFlowConstructStatistics;

public class ApplicationStatistics
extends DefaultFlowConstructStatistics {
    private AllStatistics parent;

    public ApplicationStatistics(AllStatistics parent) {
        super("Application", "application totals");
        this.parent = parent;
    }

    @Override
    public long getAverageProcessingTime() {
        long totalTime = 0L;
        long totalEvents = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            totalEvents += stats.getProcessedEvents();
            totalTime += stats.getTotalProcessingTime();
        }
        return totalEvents == 0L ? 0L : totalTime / totalEvents;
    }

    @Override
    public long getProcessedEvents() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getProcessedEvents();
        }
        return total;
    }

    @Override
    public long getMinProcessingTime() {
        long min = 0L;
        boolean first = true;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (!(stats instanceof ApplicationStatistics)) {
                long flowMin = stats.getMinProcessingTime();
                min = first ? flowMin : Math.min(min, flowMin);
            }
            first = false;
        }
        return min;
    }

    @Override
    public long getMaxProcessingTime() {
        long max = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            max = Math.max(max, stats.getMaxProcessingTime());
        }
        return max;
    }

    @Override
    public long getTotalProcessingTime() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getTotalProcessingTime();
        }
        return total;
    }

    @Override
    public long getExecutionErrors() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getExecutionErrors();
        }
        return total;
    }

    @Override
    public long getFatalErrors() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getFatalErrors();
        }
        return total;
    }

    @Override
    public long getTotalEventsReceived() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getTotalEventsReceived();
        }
        return total;
    }
}

