/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.PolicyEventConverter;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OperationPolicyProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationPolicyProcessor.class);
    private final Policy policy;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();
    private final Processor nextProcessor;

    public OperationPolicyProcessor(Policy policy, PolicyStateHandler policyStateHandler, Processor nextProcessor) {
        this.policy = policy;
        this.policyStateHandler = policyStateHandler;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public CoreEvent process(CoreEvent operationEvent) throws MuleException {
        return MessageProcessors.processToApply(operationEvent, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Mono.from(publisher).cast(PrivilegedEvent.class).flatMap(operationEvent -> {
            PolicyStateId policyStateId = new PolicyStateId(operationEvent.getContext().getCorrelationId(), this.policy.getPolicyId());
            Optional<CoreEvent> latestPolicyState = this.policyStateHandler.getLatestState(policyStateId);
            PrivilegedEvent variablesProviderEvent = (PrivilegedEvent)latestPolicyState.orElseGet(() -> PrivilegedEvent.builder(operationEvent.getContext()).message(Message.of(null)).build());
            this.policyStateHandler.updateState(policyStateId, variablesProviderEvent);
            PrivilegedEvent policyEvent = this.policyEventConverter.createEvent((PrivilegedEvent)operationEvent, variablesProviderEvent);
            Processor operationCall = this.buildOperationExecutionWithPolicyFunction(this.nextProcessor, (PrivilegedEvent)operationEvent);
            this.policyStateHandler.updateNextOperation(policyStateId.getExecutionIdentifier(), operationCall);
            return this.executePolicyChain((PrivilegedEvent)operationEvent, policyStateId, policyEvent);
        });
    }

    private Mono<PrivilegedEvent> executePolicyChain(PrivilegedEvent operationEvent, PolicyStateId policyStateId, PrivilegedEvent policyEvent) {
        return Mono.just((Object)policyEvent).doOnNext(event -> this.logPolicy(event.getContext().getId(), policyStateId.getPolicyId(), this.getMessageAttributesAsString((CoreEvent)event), "Before operation")).cast(CoreEvent.class).transform((Function)this.policy.getPolicyChain()).cast(PrivilegedEvent.class).doOnNext(policyChainResult -> this.policyStateHandler.updateState(policyStateId, (CoreEvent)policyChainResult)).map(policyChainResult -> this.policyEventConverter.createEvent((PrivilegedEvent)policyChainResult, operationEvent)).doOnNext(event -> this.logPolicy(event.getContext().getId(), policyStateId.getPolicyId(), this.getMessageAttributesAsString((CoreEvent)event), "After operation"));
    }

    private Processor buildOperationExecutionWithPolicyFunction(final Processor nextOperation, final PrivilegedEvent operationEvent) {
        return new Processor(){

            @Override
            public CoreEvent process(CoreEvent event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                return Mono.from(publisher).cast(PrivilegedEvent.class).flatMap(policyExecuteNextEvent -> {
                    PolicyStateId policyStateId = new PolicyStateId(policyExecuteNextEvent.getContext().getId(), OperationPolicyProcessor.this.policy.getPolicyId());
                    OperationPolicyProcessor.this.policyStateHandler.updateState(policyStateId, (CoreEvent)policyExecuteNextEvent);
                    return Mono.just((Object)policyExecuteNextEvent).map(event -> OperationPolicyProcessor.this.policyEventConverter.createEvent((PrivilegedEvent)event, operationEvent)).cast(CoreEvent.class).transform((Function)nextOperation).cast(PrivilegedEvent.class).map(operationResult -> OperationPolicyProcessor.this.policyEventConverter.createEvent((PrivilegedEvent)operationResult, (PrivilegedEvent)policyExecuteNextEvent));
                });
            }
        };
    }

    private String getMessageAttributesAsString(CoreEvent event) {
        if (event.getMessage() == null || event.getMessage().getAttributes() == null || event.getMessage().getAttributes().getValue() == null) {
            return "";
        }
        return event.getMessage().getAttributes().getValue().toString();
    }

    private void logPolicy(String eventId, String policyName, String message, String startingMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event Id: " + eventId + ".\n" + startingMessage + "\nPolicy:" + policyName + "\n" + message);
        }
    }
}

