/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.StreamPerEventSink;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class WorkQueueProcessingStrategyFactory
extends AbstractProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new WorkQueueProcessingStrategy(() -> muleContext.getSchedulerService().ioScheduler(this.createSchedulerConfig(muleContext, schedulersNamePrefix, ReactiveProcessor.ProcessingType.BLOCKING)));
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return WorkQueueProcessingStrategy.class;
    }

    static class WorkQueueProcessingStrategy
    extends AbstractProcessingStrategy
    implements Startable,
    Stoppable {
        private final Supplier<Scheduler> ioSchedulerSupplier;
        private Scheduler ioScheduler;

        public WorkQueueProcessingStrategy(Supplier<Scheduler> ioSchedulerSupplier) {
            this.ioSchedulerSupplier = Objects.requireNonNull(ioSchedulerSupplier);
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            return new StreamPerEventSink(pipeline, this.createOnEventConsumer());
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            return publisher -> Flux.from((Publisher)publisher).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.ioScheduler))).transform((Function)pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.ioScheduler)));
            }
            return super.onProcessor(processor);
        }

        @Override
        public void start() throws MuleException {
            this.ioScheduler = this.ioSchedulerSupplier.get();
        }

        @Override
        public void stop() throws MuleException {
            if (this.ioScheduler != null) {
                this.ioScheduler.stop();
            }
        }
    }
}

