/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.internal.routing.EventToMessageSequenceSplittingStrategy;
import org.mule.runtime.core.internal.routing.ExpressionSplittingStrategy;
import org.mule.runtime.core.internal.routing.MessageSequence;
import org.mule.runtime.core.internal.routing.SplittingStrategy;
import org.mule.runtime.core.internal.routing.outbound.AbstractMessageSequenceSplitter;
import org.mule.runtime.core.privileged.event.Acceptor;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.privileged.processor.Router;

public class Splitter
extends AbstractMessageSequenceSplitter
implements Initialisable,
Router {
    private String expression = "#[payload]";
    private SplittingStrategy<CoreEvent, MessageSequence<?>> strategy;
    private String filterOnErrorType = null;

    public Splitter() {
    }

    public Splitter(String expression, String filterOnErrorType) {
        this.expression = expression;
        this.filterOnErrorType = filterOnErrorType;
    }

    @Override
    protected MessageSequence<?> splitMessageIntoSequence(CoreEvent event) {
        return this.strategy.split(event);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        this.strategy = new EventToMessageSequenceSplittingStrategy(new ExpressionSplittingStrategy(this.muleContext.getExpressionManager(), this.expression));
        this.filterOnErrorTypeAcceptor = this.createFilterOnErrorTypeAcceptor(TemplateOnErrorHandler.createErrorType(this.muleContext.getErrorTypeRepository(), this.filterOnErrorType));
    }

    private Acceptor createFilterOnErrorTypeAcceptor(final ErrorTypeMatcher filterOnErrorTypeMatcher) {
        return new Acceptor(){

            @Override
            public boolean acceptsAll() {
                return false;
            }

            @Override
            public boolean accept(CoreEvent event) {
                return filterOnErrorTypeMatcher != null && filterOnErrorTypeMatcher.match(event.getError().get().getErrorType());
            }
        };
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFilterOnErrorType(String filterOnErrorType) {
        this.filterOnErrorType = filterOnErrorType;
    }
}

