/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.SynchronousSink;

public final class Operators {
    private Operators() {
    }

    public static BiConsumer<CoreEvent, SynchronousSink<CoreEvent>> nullSafeMap(Function<CoreEvent, CoreEvent> mapper) {
        return (event, sink) -> {
            if (event != null) {
                CoreEvent result = (CoreEvent)mapper.apply((CoreEvent)event);
                if (result != null) {
                    sink.next((Object)result);
                } else {
                    ((BaseEventContext)event.getContext()).success();
                }
            }
        };
    }

    public static Function<CoreEvent, CoreEvent> outputToTarget(CoreEvent originalEvent, String target, String targetValueExpression, ExpressionLanguage expressionManager) {
        return result -> {
            if (target != null) {
                TypedValue<?> targetValue = expressionManager.evaluate(targetValueExpression, BindingContextUtils.getTargetBindingContext(result.getMessage()));
                return CoreEvent.builder(originalEvent).addVariable(target, targetValue.getValue(), targetValue.getDataType()).build();
            }
            return result;
        };
    }

    public static <T> Subscriber<T> requestUnbounded() {
        return RequestMaxSubscriber.INSTANCE;
    }

    static final class RequestMaxSubscriber<T>
    implements Subscriber<T> {
        static final RequestMaxSubscriber INSTANCE = new RequestMaxSubscriber();

        RequestMaxSubscriber() {
        }

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        public void onNext(Object o) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    }
}

