/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.transaction.xa;

import javax.transaction.TransactionManager;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.internal.transaction.ExternalXaTransaction;
import org.mule.runtime.core.privileged.transaction.XaTransaction;

public class XaTransactionFactory
implements ExternalTransactionAwareTransactionFactory {
    private int timeout;

    @Override
    public Transaction beginTransaction(MuleContext muleContext) throws TransactionException {
        try {
            XaTransaction xat = new XaTransaction(muleContext);
            xat.setTimeout(this.timeout);
            xat.begin();
            return xat;
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    @Override
    public Transaction joinExternalTransaction(MuleContext muleContext) throws TransactionException {
        try {
            TransactionManager txManager = muleContext.getTransactionManager();
            if (txManager.getTransaction() == null) {
                return null;
            }
            ExternalXaTransaction xat = new ExternalXaTransaction(muleContext);
            xat.begin();
            return xat;
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    @Override
    public boolean isTransacted() {
        return true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

