/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtils {
    public static final int INTEGER_ERROR = -999999999;

    public static int toInt(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Unable to convert null object to int");
        }
        if (obj instanceof String) {
            return NumberUtils.toInt((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        throw new IllegalArgumentException("Unable to convert object of type: " + obj.getClass().getName() + " to int.");
    }

    private static int toInt(String str) {
        return org.apache.commons.lang3.math.NumberUtils.toInt((String)str, (int)-999999999);
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass) {
        text = text.trim();
        if (targetClass.equals(Byte.class)) {
            return (T)Byte.valueOf(text);
        }
        if (targetClass.equals(Short.class)) {
            return (T)Short.valueOf(text);
        }
        if (targetClass.equals(Integer.class)) {
            return (T)Integer.valueOf(text);
        }
        if (targetClass.equals(Long.class)) {
            return (T)Long.valueOf(text);
        }
        if (targetClass.equals(BigInteger.class)) {
            return (T)new BigInteger(text);
        }
        if (targetClass.equals(Float.class)) {
            return (T)Float.valueOf(text);
        }
        if (targetClass.equals(Double.class)) {
            return (T)Double.valueOf(text);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return (T)new BigDecimal(text);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    public static <T extends Number> T convertNumberToTargetClass(Number number, Class<T> targetClass) throws IllegalArgumentException {
        if (targetClass.isInstance(number)) {
            return (T)number;
        }
        if (targetClass.equals(Byte.class)) {
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)new Byte(number.byteValue());
        }
        if (targetClass.equals(Short.class)) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)new Short(number.shortValue());
        }
        if (targetClass.equals(Integer.class)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)new Integer(number.intValue());
        }
        if (targetClass.equals(Long.class)) {
            return (T)new Long(number.longValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            if (number instanceof BigDecimal) {
                return (T)((BigDecimal)number).toBigInteger();
            }
            return (T)BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(Float.class)) {
            return (T)new Float(number.floatValue());
        }
        if (targetClass.equals(Double.class)) {
            return (T)new Double(number.doubleValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return (T)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }
}

