/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message;

import java.util.Collection;
import java.util.Optional;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.HttpMessage;

public abstract class HttpMessageBuilder<B extends HttpMessageBuilder, M extends HttpMessage> {
    protected MultiMap<String, String> headers = new CaseInsensitiveMultiMap();
    protected HttpEntity entity = new EmptyHttpEntity();

    public HttpMessageBuilder() {
    }

    protected HttpMessageBuilder(HttpMessage httpMessage) {
        this.entity(httpMessage.getEntity());
        this.headers(httpMessage);
    }

    private void headers(HttpMessage httpMessage) {
        for (String headerName : httpMessage.getHeaderNames()) {
            this.headers.put(headerName, httpMessage.getHeaderValues(headerName));
        }
    }

    public B entity(HttpEntity entity) {
        Preconditions.checkNotNull(entity, "entity cannot be null, use an EmptyHttpEntity instead");
        this.entity = entity;
        return (B)this;
    }

    public B headers(MultiMap<String, String> headersMap) {
        headersMap.keySet().forEach(key -> this.headers.put((String)key, headersMap.getAll(key)));
        return (B)this;
    }

    public B addHeader(String name, String value) {
        this.headers.put(name, value);
        return (B)this;
    }

    public B addHeaders(String name, Collection<String> values) {
        this.headers.put(name, values);
        return (B)this;
    }

    public B removeHeader(String name) {
        this.headers.remove(name);
        return (B)this;
    }

    public Optional<String> getHeaderValue(String name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    public Collection<String> getHeaderValues(String name) {
        return this.headers.getAll(name);
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers.toImmutableMultiMap();
    }

    public abstract M build();
}

