/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message.request;

import java.net.URI;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.HttpMessageBuilder;
import org.mule.runtime.http.api.domain.message.request.DefaultHttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.utils.UriCache;

public final class HttpRequestBuilder
extends HttpMessageBuilder<HttpRequestBuilder, HttpRequest> {
    private String path;
    private URI uri;
    private String method = HttpConstants.Method.GET.name();
    private MultiMap<String, String> queryParams = new MultiMap();

    HttpRequestBuilder() {
    }

    public HttpRequestBuilder uri(String uri) {
        int queryPos = uri.indexOf("?");
        this.path = queryPos > -1 ? uri.substring(0, queryPos) : uri;
        this.uri = UriCache.getUriFromString(uri);
        return this;
    }

    public HttpRequestBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public HttpRequestBuilder method(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestBuilder method(HttpConstants.Method method) {
        this.method = method.name();
        return this;
    }

    public HttpRequestBuilder queryParams(MultiMap<String, String> queryParams) {
        queryParams.keySet().forEach(key -> this.queryParams.put((String)key, queryParams.getAll(key)));
        return this;
    }

    public HttpRequestBuilder addQueryParam(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    @Override
    public HttpRequest build() {
        Preconditions.checkNotNull(this.uri, "URI must be specified to create an HTTP request");
        return new DefaultHttpRequest(this.uri, this.path, this.method, this.headers.toImmutableMultiMap(), this.queryParams.toImmutableMultiMap(), this.entity);
    }
}

