/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorUtils;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationPluginDescriptorsResolver;

public class DefaultApplicationPluginDescriptorsResolver
implements ApplicationPluginDescriptorsResolver {
    @Override
    public List<ArtifactPluginDescriptor> resolveArtifactPluginDescriptors(Set<ArtifactPluginDescriptor> domainPluginDescriptors, Set<ArtifactPluginDescriptor> applicationArtifactPluginDescriptorsDeclared) {
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        for (ArtifactPluginDescriptor appPluginDescriptor : applicationArtifactPluginDescriptorsDeclared) {
            Optional<ArtifactPluginDescriptor> pluginDescriptor = DefaultApplicationPluginDescriptorsResolver.findPlugin(domainPluginDescriptors, appPluginDescriptor.getBundleDescriptor());
            if (!pluginDescriptor.isPresent()) {
                artifactPluginDescriptors.add(appPluginDescriptor);
                continue;
            }
            if (BundleDescriptorUtils.isCompatibleVersion(pluginDescriptor.get().getBundleDescriptor().getVersion(), appPluginDescriptor.getBundleDescriptor().getVersion())) continue;
            throw new IllegalStateException(String.format("Incompatible version of plugin '%s' (%s:%s) found. Application requires version '%s' but domain provides version '%s'", appPluginDescriptor.getName(), appPluginDescriptor.getBundleDescriptor().getGroupId(), appPluginDescriptor.getBundleDescriptor().getArtifactId(), appPluginDescriptor.getBundleDescriptor().getVersion(), pluginDescriptor.get().getBundleDescriptor().getVersion()));
        }
        return artifactPluginDescriptors;
    }

    private static Optional<ArtifactPluginDescriptor> findPlugin(Set<ArtifactPluginDescriptor> appPlugins, BundleDescriptor bundleDescriptor) {
        for (ArtifactPluginDescriptor appPlugin : appPlugins) {
            if (!appPlugin.getBundleDescriptor().getArtifactId().equals(bundleDescriptor.getArtifactId()) || !appPlugin.getBundleDescriptor().getGroupId().equals(bundleDescriptor.getGroupId())) continue;
            return Optional.of(appPlugin);
        }
        return Optional.empty();
    }
}

