/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.MuleContextListenerFactory;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactArchiveInstaller;
import org.mule.runtime.module.deployment.internal.ArtifactDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.NullDeploymentListener;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArchiveDeployer<T extends DeployableArtifact>
implements ArchiveDeployer<T> {
    public static final String ARTIFACT_NAME_PROPERTY = "artifactName";
    public static final String JAR_FILE_SUFFIX = ".jar";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    private static final Logger logger = LoggerFactory.getLogger(DefaultArchiveDeployer.class);
    private final ArtifactDeployer<T> deployer;
    private final ArtifactArchiveInstaller artifactArchiveInstaller;
    private final Map<String, ZombieArtifact> artifactZombieMap = new HashMap<String, ZombieArtifact>();
    private final File artifactDir;
    private final ObservableList<T> artifacts;
    private final ArtifactDeploymentTemplate deploymentTemplate;
    private AbstractDeployableArtifactFactory<T> artifactFactory;
    private DeploymentListener deploymentListener = new NullDeploymentListener();
    private MuleContextListenerFactory muleContextListenerFactory;

    public DefaultArchiveDeployer(ArtifactDeployer deployer, AbstractDeployableArtifactFactory artifactFactory, ObservableList<T> artifacts, ArtifactDeploymentTemplate deploymentTemplate, MuleContextListenerFactory muleContextListenerFactory) {
        this.deployer = deployer;
        this.artifactFactory = artifactFactory;
        this.artifacts = artifacts;
        this.deploymentTemplate = deploymentTemplate;
        this.artifactDir = artifactFactory.getArtifactDir();
        this.artifactArchiveInstaller = new ArtifactArchiveInstaller(this.artifactDir);
        this.muleContextListenerFactory = muleContextListenerFactory;
    }

    @Override
    public boolean isUpdatedZombieArtifact(String artifactName) {
        Collection deployedAppNames = CollectionUtils.collect(this.artifacts, (Transformer)new BeanToPropertyValueTransformer(ARTIFACT_NAME_PROPERTY));
        if (deployedAppNames.contains(artifactName) && !this.artifactZombieMap.containsKey(artifactName)) {
            return false;
        }
        ZombieArtifact zombieArtifact = this.artifactZombieMap.get(artifactName);
        return zombieArtifact == null || zombieArtifact.updatedZombieApp();
    }

    @Override
    public void undeployArtifact(String artifactId) {
        ZombieArtifact zombieArtifact = this.artifactZombieMap.get(artifactId);
        if (zombieArtifact != null) {
            if (zombieArtifact.exists()) {
                return;
            }
            this.artifactZombieMap.remove(artifactId);
        }
        DeployableArtifact artifact = (DeployableArtifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactId));
        this.undeploy(artifact);
    }

    @Override
    public File getDeploymentDirectory() {
        return this.artifactFactory.getArtifactDir();
    }

    private File installArtifact(URI artifactAchivedUri) throws IOException {
        File artifactLocation;
        try {
            artifactLocation = this.installFrom(artifactAchivedUri);
        }
        catch (Throwable t) {
            File artifactArchive = new File(artifactAchivedUri);
            String artifactName = StringUtils.removeEndIgnoreCase((String)artifactArchive.getName(), (String)JAR_FILE_SUFFIX);
            this.logDeploymentFailure(t, artifactName);
            this.addZombieFile(artifactName, artifactArchive);
            this.deploymentListener.onDeploymentFailure(artifactName, t);
            throw t;
        }
        return artifactLocation;
    }

    private void logDeploymentFailure(Throwable t, String artifactName) {
        if (ExceptionUtils.containsType(t, DeploymentStartException.class)) {
            logger.error(SplashScreen.miniSplash(String.format("Failed to deploy artifact '%s', see artifact's log for details", artifactName)));
            logger.error(t.getMessage());
        } else {
            logger.error(SplashScreen.miniSplash(String.format("Failed to deploy artifact '%s', see below", artifactName)), t);
        }
    }

    @Override
    public Map<String, Map<URI, Long>> getArtifactsZombieMap() {
        HashMap<String, Map<URI, Long>> result = new HashMap<String, Map<URI, Long>>();
        for (String artifact : this.artifactZombieMap.keySet()) {
            HashMap<URI, Long> tmpMap = new HashMap<URI, Long>();
            ZombieArtifact zombieArtifact = this.artifactZombieMap.get(artifact);
            for (Map.Entry<File, Long> file : zombieArtifact.initialResourceFiles.entrySet()) {
                tmpMap.put(file.getKey().toURI(), file.getValue());
            }
            result.put(artifact, tmpMap);
        }
        return result;
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<T> artifactFactory) {
        if (!(artifactFactory instanceof AbstractDeployableArtifactFactory)) {
            throw new IllegalArgumentException("artifactFactory is expected to be of type " + AbstractDeployableArtifactFactory.class.getName());
        }
        this.artifactFactory = (AbstractDeployableArtifactFactory)artifactFactory;
    }

    @Override
    public void undeployArtifactWithoutUninstall(T artifact) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (DeploymentException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    @Override
    public void setDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    private T deployPackagedArtifact(URI artifactUri, String artifactName, Optional<Properties> deploymentProperties) {
        ZombieArtifact zombieArtifact = this.artifactZombieMap.get(artifactName);
        if (zombieArtifact != null && zombieArtifact.isFor(artifactUri) && !zombieArtifact.updatedZombieApp()) {
            return null;
        }
        DeployableArtifact artifact = (DeployableArtifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName));
        boolean isRedeploy = artifact != null;
        try {
            if (isRedeploy) {
                this.deploymentListener.onRedeploymentStart(artifactName);
                this.deploymentTemplate.preRedeploy(artifact);
                this.undeployArtifact(artifactName);
            }
            Artifact deployedArtifact = this.deployPackagedArtifact(artifactUri, (Optional)deploymentProperties);
            if (isRedeploy) {
                this.deploymentTemplate.postRedeploy(deployedArtifact);
                this.deploymentListener.onRedeploymentSuccess(artifactName);
            }
            return (T)deployedArtifact;
        }
        catch (RuntimeException e) {
            this.deploymentListener.onRedeploymentFailure(artifactName, e);
            throw e;
        }
    }

    private T deployExplodedApp(String addedApp, Optional<Properties> deploymentProperties) throws DeploymentException {
        T artifact;
        if (logger.isInfoEnabled()) {
            logger.info("================== New Exploded Artifact: " + addedApp);
        }
        try {
            File artifactLocation = new File(this.artifactDir, addedApp);
            artifact = this.createArtifact(artifactLocation, deploymentProperties);
            this.trackArtifact(artifact);
        }
        catch (Throwable t) {
            File artifactDir1 = this.artifactDir;
            File artifactDir = new File(artifactDir1, addedApp);
            this.addZombieFile(addedApp, artifactDir);
            if (ExceptionUtils.containsType(t, DeploymentStartException.class)) {
                logger.error(SplashScreen.miniSplash(String.format("Failed to deploy artifact '%s', see artifact's log for details", addedApp)));
                logger.error(t.getMessage());
            } else {
                logger.error(SplashScreen.miniSplash(String.format("Failed to deploy artifact '%s', see below", addedApp)), t);
            }
            this.deploymentListener.onDeploymentFailure(addedApp, t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            throw new DeploymentException(I18nMessageFactory.createStaticMessage("Failed to deploy artifact: " + addedApp), t);
        }
        this.deployArtifact(artifact, deploymentProperties);
        return artifact;
    }

    private void addZombieApp(DeployableArtifact artifact) {
        if (DefaultArchiveDeployer.allResourcesExist(artifact.getResourceFiles())) {
            try {
                ArrayList<File> resourceFiles = new ArrayList<File>();
                resourceFiles.addAll(Arrays.asList(artifact.getResourceFiles()));
                if (((DeployableArtifactDescriptor)artifact.getDescriptor()).isRedeploymentEnabled()) {
                    resourceFiles.add(((DeployableArtifactDescriptor)artifact.getDescriptor()).getDescriptorFile());
                }
                this.artifactZombieMap.put(artifact.getArtifactName(), new ZombieArtifact(resourceFiles.toArray(new File[resourceFiles.size()])));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addZombieFile(String artifactName, File marker) {
        if (marker == null) {
            return;
        }
        if (!marker.exists()) {
            return;
        }
        try {
            this.artifactZombieMap.put(artifactName, new ZombieArtifact(new File[]{marker}));
        }
        catch (Exception e) {
            logger.debug(String.format("Failed to mark an exploded artifact [%s] as a zombie", marker.getName()), (Throwable)e);
        }
    }

    private T findArtifact(String artifactName) {
        return (T)((DeployableArtifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName)));
    }

    private void trackArtifact(T artifact) {
        this.preTrackArtifact(artifact);
        this.artifacts.add(artifact);
    }

    public void preTrackArtifact(T artifact) {
        T previousArtifact = this.findArtifact(artifact.getArtifactName());
        this.artifacts.remove(previousArtifact);
    }

    private void undeployArtifactWithoutRemovingData(T artifact) {
        this.undeployArtifact(artifact, false);
    }

    private void undeploy(T artifact) {
        this.undeployArtifact(artifact, true);
    }

    private void undeployArtifact(T artifact, boolean removeData) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.artifacts.remove(artifact);
            this.deployer.undeploy(artifact);
            this.artifactArchiveInstaller.uninstallArtifact(artifact.getArtifactName());
            if (removeData) {
                File dataFolder = MuleFoldersUtil.getAppDataFolder(((DeployableArtifactDescriptor)artifact.getDescriptor()).getDataFolderName());
                try {
                    FileUtils.deleteDirectory((File)dataFolder);
                }
                catch (IOException e) {
                    logger.warn(String.format("Cannot delete data folder '%s' while undeploying artifact '%s'. This could be related to some files still being used and can cause a memory leak", dataFolder, artifact.getArtifactName()), (Throwable)e);
                }
            }
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
            this.logArtifactUndeployed(artifact);
        }
        catch (RuntimeException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    private void logRequestToUndeployArtifact(T artifact) {
        if (logger.isInfoEnabled()) {
            logger.info("================== Request to Undeploy Artifact: " + artifact.getArtifactName());
        }
    }

    private void logArtifactUndeployed(T artifact) {
        if (logger.isInfoEnabled()) {
            logger.info(SplashScreen.miniSplash(String.format("Undeployed artifact '%s'", artifact.getArtifactName())));
        }
    }

    private File installFrom(URI uri) throws IOException {
        return this.artifactArchiveInstaller.installArtifact(uri);
    }

    private T createArtifact(File artifactLocation, Optional<Properties> appProperties) throws IOException {
        Artifact artifact = this.artifactFactory.createArtifact(artifactLocation, (Optional)appProperties);
        artifact.setMuleContextListener(this.muleContextListenerFactory.create(artifact.getArtifactName()));
        return (T)artifact;
    }

    private static boolean allResourcesExist(File[] resourceFiles) {
        return Arrays.stream(resourceFiles).allMatch(File::exists);
    }

    @Override
    public T deployPackagedArtifact(String zip, Optional<Properties> deploymentProperties) throws DeploymentException {
        try {
            String artifactName = StringUtils.removeEndIgnoreCase((String)zip, (String)JAR_FILE_SUFFIX);
            File artifactZip = new File(this.artifactDir, zip);
            URI uri = artifactZip.toURI();
            return this.deployPackagedArtifact(uri, artifactName, deploymentProperties);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage("Failed to deploy from zip: " + zip), (Throwable)e);
        }
    }

    @Override
    public void redeploy(T artifact, Optional<Properties> deploymentProperties) throws DeploymentException {
        if (logger.isInfoEnabled()) {
            logger.info(SplashScreen.miniSplash(String.format("Redeploying artifact '%s'", artifact.getArtifactName())));
        }
        this.deploymentListener.onRedeploymentStart(artifact.getArtifactName());
        this.deploymentTemplate.preRedeploy((Artifact)artifact);
        if (!this.artifactZombieMap.containsKey(artifact.getArtifactName())) {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            try {
                this.deployer.undeploy(artifact);
                this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
            }
            catch (Throwable e) {
                this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
                this.deploymentListener.onRedeploymentFailure(artifact.getArtifactName(), e);
            }
        }
        this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
        try {
            artifact = this.createArtifact(artifact.getLocation(), Optional.ofNullable(DeploymentPropertiesUtils.resolveDeploymentProperties(((DeployableArtifactDescriptor)artifact.getDescriptor()).getDataFolderName(), deploymentProperties)));
            this.trackArtifact(artifact);
            this.deployer.deploy(artifact);
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
            this.deploymentTemplate.postRedeploy((Artifact)artifact);
            this.deploymentListener.onRedeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable t) {
            try {
                this.logDeploymentFailure(t, artifact.getArtifactName());
                this.addZombieApp((DeployableArtifact)artifact);
                if (t instanceof DeploymentException) {
                    throw (DeploymentException)t;
                }
                String msg = "Failed to deploy artifact: " + artifact.getArtifactName();
                throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
            }
            catch (Throwable throwable) {
                this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
                this.deploymentListener.onRedeploymentFailure(artifact.getArtifactName(), t);
                throw throwable;
            }
        }
        this.artifactZombieMap.remove(artifact.getArtifactName());
    }

    @Override
    public void deployArtifact(T artifact, Optional<Properties> deploymentProperties) throws DeploymentException {
        try {
            this.trackArtifact(artifact);
            this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
            this.deployer.deploy(artifact);
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
            this.artifactZombieMap.remove(artifact.getArtifactName());
        }
        catch (Throwable t) {
            if (ExceptionUtils.containsType(t, DeploymentStartException.class)) {
                logger.error(SplashScreen.miniSplash(String.format("Failed to deploy artifact '%s', see artifact's log for details", artifact.getArtifactName())));
                logger.error(t.getMessage());
            } else {
                logger.error(SplashScreen.miniSplash(String.format("Failed to deploy artifact '%s', see below", artifact.getArtifactName())), t);
            }
            this.addZombieApp((DeployableArtifact)artifact);
            this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            throw new DeploymentException(I18nMessageFactory.createStaticMessage("Failed to deploy artifact: " + artifact.getArtifactName()), t);
        }
    }

    @Override
    public T deployPackagedArtifact(URI artifactAchivedUri, Optional<Properties> appProperties) throws DeploymentException {
        Optional<DeployableArtifact> foundMatchingArtifact = Optional.empty();
        try {
            T artifact;
            File artifactLocation = this.installArtifact(artifactAchivedUri);
            try {
                artifact = this.createArtifact(artifactLocation, appProperties);
                this.trackArtifact(artifact);
            }
            catch (Throwable t) {
                String artifactName = artifactLocation.getName();
                this.logDeploymentFailure(t, artifactName);
                foundMatchingArtifact.ifPresent(a -> this.deploymentListener.onRedeploymentFailure(a.getArtifactName(), t));
                this.addZombieFile(artifactName, artifactLocation);
                this.deploymentListener.onDeploymentFailure(artifactName, t);
                throw t;
            }
            this.deployArtifact(artifact, appProperties);
            foundMatchingArtifact.ifPresent(a -> this.deploymentListener.onRedeploymentSuccess(a.getArtifactName()));
            return artifact;
        }
        catch (Throwable t) {
            foundMatchingArtifact.ifPresent(a -> this.deploymentListener.onRedeploymentFailure(a.getArtifactName(), t));
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            String msg = "Failed to deploy from URI: " + artifactAchivedUri;
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
        }
    }

    @Override
    public T deployExplodedArtifact(String artifactDir, Optional<Properties> deploymentProperties) {
        if (!this.isUpdatedZombieArtifact(artifactDir)) {
            return null;
        }
        return this.deployExplodedApp(artifactDir, deploymentProperties);
    }

    private static class ZombieArtifact {
        Map<File, Long> initialResourceFiles = new HashMap<File, Long>();

        private ZombieArtifact(File[] resourceFiles) {
            for (File resourceFile : resourceFiles) {
                this.initialResourceFiles.put(resourceFile, resourceFile.lastModified());
            }
        }

        public boolean isFor(URI uri) {
            return this.initialResourceFiles.entrySet().stream().anyMatch(entry -> ((File)entry.getKey()).toURI().equals(uri));
        }

        public boolean updatedZombieApp() {
            return this.initialResourceFiles.entrySet().stream().anyMatch(entry -> !((Long)entry.getValue()).equals(((File)entry.getKey()).lastModified()));
        }

        public boolean exists() {
            return DefaultArchiveDeployer.allResourcesExist(this.initialResourceFiles.keySet().toArray(new File[this.initialResourceFiles.size()]));
        }
    }
}

