/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.management.stats.DefaultFlowConstructStatistics;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;

public class MuleExtensionUtils {
    private static final String INITIALIZER_EVENT = "InitializerEvent";

    private MuleExtensionUtils() {
    }

    public static ExtensionModel loadExtension(Class<?> clazz) {
        return MuleExtensionUtils.loadExtension(clazz, new HashMap<String, Object>());
    }

    public static ExtensionModel loadExtension(Class<?> clazz, Map<String, Object> params) {
        params.put("type", clazz.getName());
        params.put("version", MuleManifest.getProductVersion());
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.emptySet());
        return new DefaultJavaExtensionModelLoader().loadExtensionModel(clazz.getClassLoader(), dslResolvingContext, params);
    }

    public static CoreEvent getInitialiserEvent() {
        return MuleExtensionUtils.getInitialiserEvent(null);
    }

    public static CoreEvent getInitialiserEvent(final MuleContext muleContext) {
        FlowConstruct flowConstruct = new FlowConstruct(){

            @Override
            public Object getAnnotation(QName name) {
                return null;
            }

            @Override
            public Map<QName, Object> getAnnotations() {
                return Collections.emptyMap();
            }

            @Override
            public void setAnnotations(Map<QName, Object> annotations) {
            }

            @Override
            public ComponentLocation getLocation() {
                return null;
            }

            @Override
            public Location getRootContainerLocation() {
                return null;
            }

            @Override
            public MuleContext getMuleContext() {
                return muleContext;
            }

            @Override
            public String getServerId() {
                return "InitialiserServer";
            }

            @Override
            public String getUniqueIdString() {
                return UUID.getUUID();
            }

            @Override
            public String getName() {
                return "InitialiserEventFlow";
            }

            @Override
            public LifecycleState getLifecycleState() {
                return null;
            }

            @Override
            public FlowExceptionHandler getExceptionListener() {
                return null;
            }

            @Override
            public DefaultFlowConstructStatistics getStatistics() {
                return null;
            }
        };
        return InternalEvent.builder(EventContextFactory.create(flowConstruct, DefaultComponentLocation.fromSingleComponent(INITIALIZER_EVENT))).message(Message.of(null)).build();
    }

    public static ExtensionManager createDefaultExtensionManager() {
        return new DefaultExtensionManager();
    }
}

