/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.component.AnnotatedObjectInvocationHandler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.ObjectTypeProvider;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class TopLevelParameterObjectFactory
extends AbstractExtensionObjectFactory<Object>
implements ObjectTypeProvider {
    private DefaultObjectBuilder builder;
    private Class<?> objectClass;
    private final ObjectType objectType;
    private final ClassLoader classLoader;
    private String name;
    private Object staticProduct = null;

    public TopLevelParameterObjectFactory(ObjectType type, ClassLoader classLoader, MuleContext muleContext) {
        super(muleContext);
        this.classLoader = classLoader;
        this.objectType = type;
        this.objectClass = ClassUtils.withContextClassLoader(classLoader, () -> AnnotatedObjectInvocationHandler.addAnnotationsToClass(JavaTypeUtils.getType(type)));
        this.builder = new DefaultObjectBuilder(this.objectClass);
    }

    @Override
    public Object doGetObject() throws Exception {
        return ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.resolveParameters(this.objectType, this.builder);
            this.resolveParameterGroups(this.objectType, this.builder);
            this.injectFields();
            ObjectBuilderValueResolver resolver = new ObjectBuilderValueResolver(this.builder, this.muleContext);
            if (resolver.isDynamic()) {
                return resolver;
            }
            CoreEvent initialiserEvent = null;
            try {
                initialiserEvent = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
                this.staticProduct = resolver.resolve(ValueResolvingContext.from(initialiserEvent));
                this.muleContext.getInjector().inject(this.staticProduct);
                Object object = this.staticProduct;
                return object;
            }
            finally {
                if (initialiserEvent != null) {
                    ((BaseEventContext)initialiserEvent.getContext()).success();
                }
            }
        }, Exception.class, exception -> {
            throw exception;
        });
    }

    private void injectFields() {
        this.builder.setEncoding(this.muleContext.getConfiguration().getDefaultEncoding());
        if (this.name != null) {
            this.builder.setName(this.name);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Class<?> getObjectType() {
        return this.objectClass;
    }
}

