/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.TypedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithParametersDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.metadata.resolving.StaticResolver;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.fixed.AttributesJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.AttributesXmlType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputXmlType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputXmlType;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.enricher.MetadataTypeEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;

public final class CustomStaticTypeDeclarationEnricher
implements DeclarationEnricher {
    private MetadataTypeEnricher enricher = new MetadataTypeEnricher();

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.INITIALIZE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(WithOperationsDeclaration owner, OperationDeclaration operation) {
                operation.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).ifPresent(method -> {
                    CustomStaticTypeDeclarationEnricher.this.getOutputType(method).ifPresent(type -> CustomStaticTypeDeclarationEnricher.this.declareCustomType(operation.getOutput(), type));
                    CustomStaticTypeDeclarationEnricher.this.getAttributesType(method).ifPresent(type -> CustomStaticTypeDeclarationEnricher.this.declareCustomType(operation.getOutputAttributes(), type));
                });
                this.declareParametersCustomStaticTypes(operation);
            }

            @Override
            protected void onSource(WithSourcesDeclaration owner, SourceDeclaration source) {
                source.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(clazz -> {
                    CustomStaticTypeDeclarationEnricher.this.getOutputType(clazz).ifPresent(type -> CustomStaticTypeDeclarationEnricher.this.declareCustomType(source.getOutput(), type));
                    CustomStaticTypeDeclarationEnricher.this.getAttributesType(clazz).ifPresent(type -> CustomStaticTypeDeclarationEnricher.this.declareCustomType(source.getOutputAttributes(), type));
                });
                source.getSuccessCallback().ifPresent(this::declareParametersCustomStaticTypes);
                source.getErrorCallback().ifPresent(this::declareParametersCustomStaticTypes);
            }

            private void declareParametersCustomStaticTypes(WithParametersDeclaration operation) {
                for (ParameterDeclaration param : operation.getAllParameters()) {
                    param.getModelProperty(ImplementingParameterModelProperty.class).map(ImplementingParameterModelProperty::getParameter).ifPresent(annotated -> CustomStaticTypeDeclarationEnricher.this.getInputType(annotated).ifPresent(type -> CustomStaticTypeDeclarationEnricher.this.declareCustomType(param, type)));
                }
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private Optional<MetadataType> getAttributesType(AnnotatedElement element) {
        AttributesXmlType xml = element.getAnnotation(AttributesXmlType.class);
        if (xml != null) {
            return this.getXmlType(xml.schema(), xml.qname());
        }
        AttributesJsonType json = element.getAnnotation(AttributesJsonType.class);
        if (json != null) {
            return this.getJsonType(json.schema());
        }
        OutputResolver resolver = element.getAnnotation(OutputResolver.class);
        if (resolver != null && this.isStaticResolver(resolver.attributes())) {
            return this.getCustomStaticType(resolver.attributes());
        }
        MetadataScope scope = element.getAnnotation(MetadataScope.class);
        if (scope != null && this.isStaticResolver(scope.attributesResolver())) {
            return this.getCustomStaticType(scope.attributesResolver());
        }
        return Optional.empty();
    }

    private Optional<MetadataType> getOutputType(AnnotatedElement element) {
        OutputXmlType xml = element.getAnnotation(OutputXmlType.class);
        if (xml != null) {
            return this.getXmlType(xml.schema(), xml.qname());
        }
        OutputJsonType json = element.getAnnotation(OutputJsonType.class);
        if (json != null) {
            return this.getJsonType(json.schema());
        }
        OutputResolver resolver = element.getAnnotation(OutputResolver.class);
        if (resolver != null && this.isStaticResolver(resolver.output())) {
            return this.getCustomStaticType(resolver.output());
        }
        MetadataScope scope = element.getAnnotation(MetadataScope.class);
        if (scope != null && this.isStaticResolver(scope.outputResolver())) {
            return this.getCustomStaticType(scope.outputResolver());
        }
        return Optional.empty();
    }

    private Optional<MetadataType> getInputType(AnnotatedElement element) {
        InputXmlType xml = element.getAnnotation(InputXmlType.class);
        if (xml != null) {
            return this.getXmlType(xml.schema(), xml.qname());
        }
        InputJsonType json = element.getAnnotation(InputJsonType.class);
        if (json != null) {
            return this.getJsonType(json.schema());
        }
        TypeResolver resolver = element.getAnnotation(TypeResolver.class);
        if (resolver != null && this.isStaticResolver(resolver.value())) {
            return this.getCustomStaticType(resolver.value());
        }
        return Optional.empty();
    }

    private <T extends BaseDeclaration> void declareCustomType(T declaration, MetadataType target) {
        MetadataType type = ((TypedDeclaration)((Object)declaration)).getType();
        Class clazz = ExtensionMetadataTypeUtils.getType(type).orElseThrow(() -> new IllegalStateException("Could not find class in type [" + type + "]"));
        HashSet<TypeAnnotation> a = new HashSet<TypeAnnotation>(Arrays.asList(new ClassInformationAnnotation(clazz), new CustomDefinedStaticTypeAnnotation()));
        ((TypedDeclaration)((Object)declaration)).setType(this.enricher.enrich(target, a), false);
    }

    private Optional<MetadataType> getCustomStaticType(Class<?> resolver) {
        try {
            return Optional.of(((StaticResolver)resolver.newInstance()).getStaticMetadata());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Can't obtain static type for element", e);
        }
    }

    private Optional<MetadataType> getJsonType(String schema) {
        String schemaContent = IOUtils.toString(this.getSchemaContent(schema));
        Optional<MetadataType> type = new JsonTypeLoader(schemaContent).load(null);
        if (!type.isPresent()) {
            throw new IllegalArgumentException("Could not load type from Json schema [" + schema + "]");
        }
        return type;
    }

    private Optional<MetadataType> getXmlType(String schema, String qname) {
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            if (StringUtils.isBlank((CharSequence)qname)) {
                throw new IllegalStateException("[" + schema + "] was specified but no associated QName to find in schema");
            }
            Optional<MetadataType> type = new XmlTypeLoader(SchemaCollector.getInstance().addSchema(schema, this.getSchemaContent(schema))).load(qname);
            if (!type.isPresent()) {
                throw new IllegalArgumentException("Type [" + qname + "] wasn't found in XML schema [" + schema + "]");
            }
            return type;
        }
        return Optional.empty();
    }

    private InputStream getSchemaContent(String schemaName) {
        InputStream schema = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaName);
        if (schema == null) {
            throw new IllegalArgumentException("Can't load schema [" + schemaName + "]. It was not found in the resources.");
        }
        return schema;
    }

    private boolean isStaticResolver(Class<?> resolverClazz) {
        return StaticResolver.class.isAssignableFrom(resolverClazz);
    }
}

