/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import java.util.List;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class ObjectStoreParameterDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration extension = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        final Reference<Boolean> hasObjectStoreParams = new Reference<Boolean>(false);
        new IdempotentDeclarationWalker(){

            @Override
            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration parameter) {
                if (ObjectStoreParameterDeclarationEnricher.this.isObjectStore(parameter.getType())) {
                    List<StereotypeModel> stereotypes = parameter.getAllowedStereotypeModels();
                    if (!stereotypes.contains(MuleStereotypes.OBJECT_STORE)) {
                        stereotypes.add(MuleStereotypes.OBJECT_STORE);
                    }
                    hasObjectStoreParams.set(true);
                }
            }
        }.walk(extension);
        if (hasObjectStoreParams.get().booleanValue() && !this.isObjectStoreAlreadyImported(extension)) {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            extension.getImportedTypes().add(new ImportedTypeModel((ObjectType)typeLoader.load((Type)((Object)ObjectStore.class))));
        }
    }

    private boolean isObjectStoreAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().filter(model -> this.isObjectStore(model.getImportedType())).findAny().isPresent();
    }

    private boolean isObjectStore(MetadataType type) {
        return MetadataTypeUtils.getTypeId(type).filter(typeId -> ObjectStore.class.getName().equals(typeId)).isPresent();
    }
}

