/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.NullSafeTypeAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.validation.ModelValidationUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class NullSafeModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        new ExtensionWalker(){

            @Override
            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, final ParameterModel model) {
                model.getType().accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitObject(ObjectType objectType) {
                        if (objectType.getMetadataFormat().equals(MetadataFormat.JAVA) && !ExtensionMetadataTypeUtils.isMap(objectType)) {
                            objectType.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).ifPresent(typeId -> typeLoader.load((String)typeId).ifPresent(fieldMetadataType -> objectType.getFields().stream().filter(f -> f.getAnnotation(NullSafeTypeAnnotation.class).isPresent()).forEach(f -> this.validateField(MetadataTypeUtils.getLocalPart(f), (ObjectFieldType)f, JavaTypeUtils.getType(fieldMetadataType), f.getAnnotation(NullSafeTypeAnnotation.class).get()))));
                        }
                    }

                    private void validateField(final String fieldName, ObjectFieldType field, final Class<?> declaringClass, NullSafeTypeAnnotation nullSafeTypeAnnotation) {
                        final Class<?> nullSafeType = nullSafeTypeAnnotation.getType();
                        final Class fieldType = JavaTypeUtils.getType(field.getValue());
                        final boolean hasDefaultOverride = nullSafeTypeAnnotation.hasDefaultOverride();
                        field.getValue().accept(new BasicTypeMetadataVisitor(){

                            @Override
                            protected void visitBasicType(MetadataType metadataType) {
                                problemsReporter.addError(new Problem(extensionModel, String.format("Field '%s' in class '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex types (Pojos, Lists, Maps)", fieldName, declaringClass.getName(), NullSafe.class.getSimpleName(), fieldType.getName())));
                            }

                            @Override
                            public void visitArrayType(ArrayType arrayType) {
                                if (hasDefaultOverride) {
                                    problemsReporter.addError(new Problem(extensionModel, String.format("Field '%s' in class '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Collections", fieldName, declaringClass.getName(), NullSafe.class.getSimpleName(), fieldType.getName())));
                                }
                            }

                            @Override
                            public void visitObject(ObjectType objectType) {
                                String requiredFields = objectType.getFields().stream().filter(f -> f.isRequired() && !ExtensionMetadataTypeUtils.isFlattenedParameterGroup(f)).map(MetadataTypeUtils::getLocalPart).collect(Collectors.joining(", "));
                                if (!StringUtils.isBlank((CharSequence)requiredFields) && ModelValidationUtils.isCompiletime(extensionModel)) {
                                    problemsReporter.addError(new Problem(model, String.format("Class '%s' cannot be used with '@%s' parameter since it contains non optional fields: [%s]", ExtensionMetadataTypeUtils.getId(objectType).orElse(""), NullSafe.class.getSimpleName(), requiredFields)));
                                }
                                if (objectType.isOpen()) {
                                    if (hasDefaultOverride) {
                                        problemsReporter.addError(new Problem(model, String.format("Field '%s' in class '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Maps", fieldName, declaringClass.getName(), NullSafe.class.getSimpleName(), fieldType.getName())));
                                    }
                                    return;
                                }
                                if (hasDefaultOverride && IntrospectionUtils.isInstantiable(fieldType)) {
                                    problemsReporter.addError(new Problem(model, String.format("Field '%s' in class '%s' is annotated with '@%s' is of concrete type '%s', but a 'defaultImplementingType' was provided. Type override is not allowed for concrete types", fieldName, declaringClass.getName(), NullSafe.class.getSimpleName(), fieldType.getName())));
                                }
                                if (!IntrospectionUtils.isInstantiable(nullSafeType)) {
                                    problemsReporter.addError(new Problem(model, String.format("Field '%s' in class '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex instantiable types (Pojos, Lists, Maps)", fieldName, declaringClass.getName(), NullSafe.class.getSimpleName(), nullSafeType.getName())));
                                }
                                if (hasDefaultOverride && !fieldType.isAssignableFrom(nullSafeType)) {
                                    problemsReporter.addError(new Problem(model, String.format("Field '%s' in class '%s' is annotated with '@%s' of type '%s', but provided type '%s is not a subtype of the parameter's type", fieldName, declaringClass.getName(), NullSafe.class.getSimpleName(), fieldType.getName(), nullSafeType.getName())));
                                }
                            }
                        });
                    }
                });
            }
        }.walk(extensionModel);
    }
}

