/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataAttributes;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.construct.ImmutableConstructModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.metadata.MetadataInputDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeyIdObjectResolver;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeysDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataOutputDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;

public final class MetadataMediator<T extends ComponentModel> {
    protected final T component;
    private final List<ParameterModel> metadataKeyParts;
    private final MetadataKeysDelegate keysDelegate;
    private final MetadataOutputDelegate outputDelegate;
    private final MetadataInputDelegate inputDelegate;
    private final MetadataKeyIdObjectResolver keyIdObjectResolver;
    private String keyContainerName = null;

    public MetadataMediator(T componentModel) {
        this.component = componentModel;
        this.metadataKeyParts = this.getMetadataKeyParts((ComponentModel)((Object)componentModel));
        this.keysDelegate = new MetadataKeysDelegate((ComponentModel)((Object)componentModel), this.metadataKeyParts);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver((ComponentModel)this.component);
        this.outputDelegate = new MetadataOutputDelegate((ComponentModel)((Object)componentModel));
        this.inputDelegate = new MetadataInputDelegate((ComponentModel)((Object)componentModel));
        componentModel.getModelProperty(MetadataKeyIdModelProperty.class).ifPresent(keyIdMP -> {
            this.keyContainerName = keyIdMP.getParameterName();
        });
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context) {
        return this.keysDelegate.getMetadataKeys(context);
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context, ParameterValueResolver metadataKeyResolver) {
        MetadataResult<Object> keyValueResult = this.getMetadataKeyObjectValue(metadataKeyResolver);
        if (!keyValueResult.isSuccess()) {
            return keyValueResult;
        }
        return this.keysDelegate.getMetadataKeys(context, keyValueResult.get());
    }

    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, MetadataKey key) {
        try {
            Object resolvedKey = this.keyIdObjectResolver.resolve(key);
            return this.getMetadata(context, resolvedKey, MetadataAttributes.builder().withKey(key));
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent());
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, ParameterValueResolver metadataKeyResolver) {
        try {
            MetadataResult<Object> keyValueResult = this.getMetadataKeyObjectValue(metadataKeyResolver);
            if (!keyValueResult.isSuccess()) {
                return keyValueResult;
            }
            Object keyValue = keyValueResult.get();
            if (keyValue == null && !this.keyIdObjectResolver.isKeyLess()) {
                return MetadataResult.failure(MetadataFailure.Builder.newFailure().withFailureCode(FailureCode.INVALID_METADATA_KEY).withMessage("MetadataKey resolved to null").onComponent());
            }
            MetadataAttributes.MetadataAttributesBuilder builder = MetadataAttributes.builder();
            if (!this.keyIdObjectResolver.isKeyLess()) {
                builder.withKey(this.keyIdObjectResolver.reconstructKeyFromType(keyValue));
            }
            return this.getMetadata(context, keyValue, builder);
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent());
        }
    }

    private MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, Object keyValue, MetadataAttributes.MetadataAttributesBuilder attributesBuilder) {
        MetadataResult<OutputMetadataDescriptor> output = this.outputDelegate.getOutputMetadataDescriptor(context, keyValue);
        MetadataResult<InputMetadataDescriptor> input = this.inputDelegate.getInputMetadataDescriptors(context, keyValue);
        if (output.isSuccess() && input.isSuccess()) {
            MetadataAttributes metadataAttributes = this.getMetadataAttributes(attributesBuilder, this.outputDelegate, input.get());
            T model = this.getTypedModel(input.get(), output.get());
            return MetadataResult.success(ComponentMetadataDescriptor.builder(model).withAttributes(metadataAttributes).build());
        }
        ImmutableList failures = ImmutableList.builder().addAll(output.getFailures()).addAll(input.getFailures()).build();
        return MetadataResult.failure(ComponentMetadataDescriptor.builder(this.component).build(), (List<MetadataFailure>)failures);
    }

    private T getTypedModel(final InputMetadataDescriptor inputMetadataDescriptor, final OutputMetadataDescriptor outputMetadataDescriptor) {
        final Reference typedModel = new Reference();
        this.component.accept(new ComponentModelVisitor(){

            @Override
            public void visit(ConstructModel constructModel) {
                typedModel.set(new ImmutableConstructModel(constructModel.getName(), constructModel.getDescription(), MetadataMediator.this.resolveParameterGroupModelType(constructModel.getParameterGroupModels(), inputMetadataDescriptor.getAllParameters()), constructModel.getNestedComponents(), constructModel.allowsTopLevelDeclaration(), constructModel.getDisplayModel().orElse(null), constructModel.getErrorModels(), constructModel.getStereotype(), constructModel.getModelProperties()));
            }

            @Override
            public void visit(OperationModel operationModel) {
                OutputModel typedOutputModel = MetadataMediator.this.resolveOutputModelType(operationModel.getOutput(), outputMetadataDescriptor.getPayloadMetadata());
                OutputModel typedAttributesModel = MetadataMediator.this.resolveOutputModelType(operationModel.getOutputAttributes(), outputMetadataDescriptor.getAttributesMetadata());
                typedModel.set(new ImmutableOperationModel(operationModel.getName(), operationModel.getDescription(), MetadataMediator.this.resolveParameterGroupModelType(operationModel.getParameterGroupModels(), inputMetadataDescriptor.getAllParameters()), operationModel.getNestedComponents(), typedOutputModel, typedAttributesModel, operationModel.isBlocking(), operationModel.getExecutionType(), operationModel.requiresConnection(), operationModel.isTransactional(), operationModel.supportsStreaming(), operationModel.getDisplayModel().orElse(null), operationModel.getErrorModels(), operationModel.getStereotype(), operationModel.getModelProperties(), operationModel.getNotificationModels()));
            }

            @Override
            public void visit(SourceModel sourceModel) {
                OutputModel typedOutputModel = MetadataMediator.this.resolveOutputModelType(sourceModel.getOutput(), outputMetadataDescriptor.getPayloadMetadata());
                OutputModel typedAttributesModel = MetadataMediator.this.resolveOutputModelType(sourceModel.getOutputAttributes(), outputMetadataDescriptor.getAttributesMetadata());
                typedModel.set(new ImmutableSourceModel(sourceModel.getName(), sourceModel.getDescription(), sourceModel.hasResponse(), true, MetadataMediator.this.resolveParameterGroupModelType(sourceModel.getParameterGroupModels(), inputMetadataDescriptor.getAllParameters()), sourceModel.getNestedComponents(), typedOutputModel, typedAttributesModel, MetadataMediator.this.resolveSourceCallbackType(sourceModel.getSuccessCallback(), inputMetadataDescriptor.getAllParameters()), MetadataMediator.this.resolveSourceCallbackType(sourceModel.getErrorCallback(), inputMetadataDescriptor.getAllParameters()), MetadataMediator.this.resolveSourceCallbackType(sourceModel.getTerminateCallback(), inputMetadataDescriptor.getAllParameters()), sourceModel.requiresConnection(), sourceModel.isTransactional(), sourceModel.supportsStreaming(), sourceModel.getDisplayModel().orElse(null), sourceModel.getStereotype(), sourceModel.getErrorModels(), sourceModel.getModelProperties(), sourceModel.getNotificationModels()));
            }
        });
        return (T)((ComponentModel)typedModel.get());
    }

    private MetadataAttributes getMetadataAttributes(MetadataAttributes.MetadataAttributesBuilder attributesBuilder, MetadataOutputDelegate outputDelegate, InputMetadataDescriptor input) {
        outputDelegate.getCategoryName().ifPresent(attributesBuilder::withCategoryName);
        outputDelegate.getOutputResolver().ifPresent(r -> attributesBuilder.withOutputResolver(r.getResolverName()));
        outputDelegate.getOutputAttributesResolver().ifPresent(r -> attributesBuilder.withOutputAttributesResolver(r.getResolverName()));
        input.getAllParameters().forEach((key, value) -> attributesBuilder.withParameterResolver((String)key, this.inputDelegate.getParameterResolver((String)key).getResolverName()));
        return attributesBuilder.build();
    }

    private MetadataResult<Object> getMetadataKeyObjectValue(ParameterValueResolver keyValueResolver) {
        try {
            Object keyValue = this.getContainerName().isPresent() ? keyValueResolver.getParameterValue(this.getContainerName().get()) : null;
            return MetadataResult.success(keyValue);
        }
        catch (Exception e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent());
        }
    }

    private List<ParameterModel> getMetadataKeyParts(ComponentModel componentModel) {
        return componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    private Optional<String> getContainerName() {
        return Optional.ofNullable(this.keyContainerName);
    }

    private List<ParameterGroupModel> resolveParameterGroupModelType(List<ParameterGroupModel> untypedParameterGroups, Map<String, ParameterMetadataDescriptor> inputTypeDescriptors) {
        LinkedList<ParameterGroupModel> parameterGroups = new LinkedList<ParameterGroupModel>();
        untypedParameterGroups.forEach(parameterGroup -> {
            LinkedList<ParameterModel> parameters = new LinkedList<ParameterModel>();
            parameterGroup.getParameterModels().forEach(parameterModel -> {
                ParameterMetadataDescriptor parameterMetadataDescriptor = (ParameterMetadataDescriptor)inputTypeDescriptors.get(parameterModel.getName());
                ImmutableParameterModel typedParameterModel = new ImmutableParameterModel(parameterModel.getName(), parameterModel.getDescription(), parameterMetadataDescriptor.getType(), parameterMetadataDescriptor.isDynamic(), parameterModel.isRequired(), parameterModel.isOverrideFromConfig(), parameterModel.getExpressionSupport(), parameterModel.getDefaultValue(), parameterModel.getRole(), parameterModel.getDslConfiguration(), parameterModel.getDisplayModel().orElse(null), parameterModel.getLayoutModel().orElse(null), parameterModel.getValueProviderModel().orElse(null), parameterModel.getAllowedStereotypes(), parameterModel.getModelProperties());
                parameters.add(typedParameterModel);
            });
            parameterGroups.add(new ImmutableParameterGroupModel(parameterGroup.getName(), parameterGroup.getDescription(), parameters, parameterGroup.getExclusiveParametersModels(), parameterGroup.isShowInDsl(), parameterGroup.getDisplayModel().orElse(null), parameterGroup.getLayoutModel().orElse(null), parameterGroup.getModelProperties()));
        });
        return parameterGroups;
    }

    private Optional<SourceCallbackModel> resolveSourceCallbackType(Optional<SourceCallbackModel> sourceCallbackModel, Map<String, ParameterMetadataDescriptor> inputTypeDescriptors) {
        return sourceCallbackModel.map(cb -> new ImmutableSourceCallbackModel(cb.getName(), cb.getDescription(), this.resolveParameterGroupModelType(cb.getParameterGroupModels(), inputTypeDescriptors), cb.getDisplayModel().orElse(null), cb.getModelProperties()));
    }

    private OutputModel resolveOutputModelType(OutputModel untypedModel, TypeMetadataDescriptor typeMetadataDescriptor) {
        return new ImmutableOutputModel(untypedModel.getDescription(), typeMetadataDescriptor.getType(), typeMetadataDescriptor.isDynamic(), untypedModel.getModelProperties());
    }
}

