/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connection.ErrorTypeHandlerConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.HasDelegate;
import org.mule.runtime.core.internal.connection.PoolingConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class DefaultConnectionProviderObjectBuilder<C>
extends ConnectionProviderObjectBuilder<C> {
    DefaultConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, ExtensionModel extensionModel, MuleContext muleContext) {
        super(providerModel, resolverSet, extensionModel, muleContext);
    }

    public DefaultConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, MuleContext muleContext) {
        super(providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, muleContext);
    }

    @Override
    public final Pair<ConnectionProvider<C>, ResolverSetResult> build(ResolverSetResult result) throws MuleException {
        ConnectionProvider<C> provider = this.doBuild(result);
        this.muleContext.getInjector().inject(provider);
        provider = this.applyExtensionClassLoaderProxy(provider);
        provider = this.applyConnectionManagement(provider);
        provider = this.applyErrorHandling(provider);
        return new Pair<ConnectionProvider<C>, ResolverSetResult>(provider, result);
    }

    protected ConnectionProvider<C> doBuild(ResolverSetResult result) throws MuleException {
        ConnectionProvider provider = (ConnectionProvider)((Pair)super.build(result)).getFirst();
        IntrospectionUtils.injectFields(this.providerModel, provider, this.ownerConfigName, this.muleContext.getConfiguration().getDefaultEncoding());
        return provider;
    }

    private ConnectionProvider<C> applyErrorHandling(ConnectionProvider<C> provider) {
        return new ErrorTypeHandlerConnectionProviderWrapper<C>(provider, this.extensionModel, this.reconnectionConfig, this.muleContext);
    }

    private ConnectionProvider<C> applyConnectionManagement(ConnectionProvider<C> provider) {
        ConnectionManagementType connectionManagementType = this.providerModel.getConnectionManagementType();
        provider = connectionManagementType == ConnectionManagementType.POOLING ? new PoolingConnectionProviderWrapper<C>(provider, this.poolingProfile, this.reconnectionConfig) : new ReconnectableConnectionProviderWrapper<C>(provider, this.reconnectionConfig);
        return provider;
    }

    private ConnectionProvider<C> applyExtensionClassLoaderProxy(ConnectionProvider provider) {
        Enhancer enhancer = new Enhancer();
        ClassLoader classLoader = MuleExtensionUtils.getClassLoader(this.extensionModel);
        enhancer.setInterfaces(this.getProxyInterfaces(provider));
        enhancer.setCallback((Callback)((MethodInterceptor)(o, method, objects, methodProxy) -> {
            Reference resultReference = new Reference();
            Reference errorReference = new Reference();
            if (method.getDeclaringClass().equals(HasDelegate.class) && method.getName().equals("getDelegate")) {
                return provider;
            }
            ClassUtils.withContextClassLoader(classLoader, () -> {
                try {
                    resultReference.set(method.invoke((Object)provider, objects));
                }
                catch (InvocationTargetException e) {
                    errorReference.set(e.getTargetException());
                }
                catch (Throwable t) {
                    errorReference.set(t);
                }
            });
            if (errorReference.get() != null) {
                throw (Throwable)errorReference.get();
            }
            return resultReference.get();
        }));
        return (ConnectionProvider)enhancer.create();
    }

    private Class[] getProxyInterfaces(ConnectionProvider provider) {
        List originalInterfaces = org.apache.commons.lang3.ClassUtils.getAllInterfaces(provider.getClass());
        Class[] runtimeInterfaces = this.filterNonRuntimeInterfaces(originalInterfaces);
        int length = runtimeInterfaces.length;
        Class[] newInterfaces = new Class[length + 1];
        boolean alreadyExists = false;
        for (int i = 0; i < length; ++i) {
            Class<?> anInterface = runtimeInterfaces[i];
            if (anInterface.equals(HasDelegate.class)) {
                alreadyExists = true;
            }
            newInterfaces[i] = anInterface;
        }
        if (!alreadyExists) {
            newInterfaces[length] = HasDelegate.class;
            return newInterfaces;
        }
        return runtimeInterfaces;
    }

    private Class<?>[] filterNonRuntimeInterfaces(List<Class<?>> interfaces) {
        return (Class[])interfaces.stream().filter(clazz -> {
            try {
                Initialisable.class.getClassLoader().loadClass(clazz.getName());
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }).toArray(Class[]::new);
    }
}

