/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class OAuthConnectionProviderWrapper<C>
extends ReconnectableConnectionProviderWrapper<C>
implements NoConnectivityTest {
    private final OAuthConfig oauthConfig;
    private final Map<Field, String> callbackValues;
    private final ExtensionsOAuthManager oauthManager;
    private final FieldSetter<ConnectionProvider<C>, AuthorizationCodeState> authCodeStateSetter;
    private final Once.RunOnce dance;

    public OAuthConnectionProviderWrapper(ConnectionProvider<C> delegate, OAuthConfig oauthConfig, Map<Field, String> callbackValues, ExtensionsOAuthManager oauthManager, ReconnectionConfig reconnectionConfig) {
        super(delegate, reconnectionConfig);
        this.oauthConfig = oauthConfig;
        this.oauthManager = oauthManager;
        this.authCodeStateSetter = this.getAuthCodeStateSetter(delegate);
        this.callbackValues = Collections.unmodifiableMap(callbackValues);
        this.dance = Once.of(this::updateAuthState);
    }

    @Override
    public C connect() throws ConnectionException {
        this.dance.runOnce();
        return super.connect();
    }

    public void updateAuthState() {
        ResourceOwnerOAuthContext context = this.getContext();
        ConnectionProvider delegate = this.getDelegate();
        this.authCodeStateSetter.set(delegate, ExtensionsOAuthUtils.toAuthorizationCodeState(this.oauthConfig, context));
        Map<String, Object> responseParameters = context.getTokenResponseParameters();
        this.callbackValues.keySet().forEach(field -> {
            String key = field.getName();
            if (responseParameters.containsKey(key)) {
                new FieldSetter((Field)field).set(delegate, responseParameters.get(key));
            }
        });
    }

    public String getResourceOwnerId() {
        return this.getContext().getResourceOwnerId();
    }

    private FieldSetter<ConnectionProvider<C>, AuthorizationCodeState> getAuthCodeStateSetter(ConnectionProvider<C> delegate) {
        List stateFields = IntrospectionUtils.getFields(delegate.getClass()).stream().filter(f -> f.getType().equals(AuthorizationCodeState.class)).collect(Collectors.toList());
        if (stateFields.size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' uses OAuth2 authorization code grant type and thus should contain one (and only one) field of type %s. %d were found", delegate.getClass().getName(), AuthorizationCodeState.class.getName(), stateFields.size()));
        }
        return new FieldSetter<ConnectionProvider<C>, AuthorizationCodeState>((Field)stateFields.get(0));
    }

    private ResourceOwnerOAuthContext getContext() {
        return this.oauthManager.getOAuthContext(this.oauthConfig).orElseThrow(() -> new IllegalArgumentException("OAuth authorization dance not yet performed for resourceOwnerId " + this.oauthConfig.getAuthCodeConfig().getResourceOwnerId()));
    }

    @Override
    public void start() throws MuleException {
        this.oauthManager.register(this.oauthConfig);
        super.start();
    }
}

