/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

class ExpressionBasedParameterResolver<T>
implements ParameterResolver<T>,
Initialisable {
    private final String expression;
    private final ValueResolvingContext context;
    private final MetadataType metadataType;
    private TypeSafeExpressionValueResolver<T> valueResolver;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    @Inject
    private MuleContext muleContext;
    private Class<T> type;

    ExpressionBasedParameterResolver(String expression, Class<T> type, ValueResolvingContext context, MetadataType metadataType) {
        this.expression = expression;
        this.type = type;
        this.context = context;
        this.metadataType = metadataType;
    }

    @Override
    public T resolve() {
        try {
            return this.valueResolver.resolve(this.context);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public Optional<String> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.valueResolver = new TypeSafeExpressionValueResolver<T>(this.expression, this.type, this.metadataType);
        this.valueResolver.setExtendedExpressionManager(this.extendedExpressionManager);
        this.valueResolver.setTransformationService(this.transformationService);
        LifecycleUtils.initialiseIfNeeded(this.valueResolver, this.muleContext);
    }

    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    public void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }
}

