/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeTransformer;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class TypeSafeValueResolverWrapper<T>
implements ValueResolver<T>,
Initialisable {
    private final Class<T> expectedType;
    private ValueResolver valueResolverDelegate;
    private Resolver<T> resolver;
    @Inject
    private TransformationService transformationService;
    @Inject
    private MuleContext muleContext;

    public TypeSafeValueResolverWrapper(ValueResolver valueResolverDelegate, Class<T> expectedType) {
        this.expectedType = expectedType;
        this.valueResolverDelegate = valueResolverDelegate;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        return this.resolver.resolve(context);
    }

    @Override
    public boolean isDynamic() {
        return this.valueResolverDelegate.isDynamic();
    }

    @Override
    public void initialise() throws InitialisationException {
        TypeSafeTransformer typeSafeTransformer = new TypeSafeTransformer(this.transformationService);
        LifecycleUtils.initialiseIfNeeded(this.valueResolverDelegate, this.muleContext);
        this.resolver = context -> {
            Object resolvedValue = this.valueResolverDelegate.resolve(context);
            return ClassUtils.isInstance(this.expectedType, resolvedValue) ? resolvedValue : typeSafeTransformer.transform(resolvedValue, DataType.fromObject(resolvedValue), DataType.fromType(this.expectedType));
        };
        if (!this.valueResolverDelegate.isDynamic()) {
            this.resolver = new CachedResolver(this.resolver);
        }
    }

    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    private class CachedResolver
    implements Resolver<T> {
        private Resolver<T> resolver = context -> {
            Object resolvedValue = resolver.resolve(context);
            this.resolver = c -> resolvedValue;
            return resolvedValue;
        };

        private CachedResolver(Resolver<T> resolver) {
        }

        @Override
        public T resolve(ValueResolvingContext context) throws MuleException {
            return this.resolver.resolve(context);
        }
    }

    @FunctionalInterface
    private static interface Resolver<T> {
        public T resolve(ValueResolvingContext var1) throws MuleException;
    }
}

