/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;

public class DefaultStreamingHelper
implements StreamingHelper {
    private final CursorProviderFactory cursorProviderFactory;
    private final StreamingManager streamingManager;
    private final CoreEvent event;

    public DefaultStreamingHelper(CursorProviderFactory cursorProviderFactory, StreamingManager streamingManager, CoreEvent event) {
        this.cursorProviderFactory = cursorProviderFactory;
        this.streamingManager = streamingManager;
        this.event = event;
    }

    @Override
    public <K> Map<K, Object> resolveCursors(Map<K, Object> map, boolean recursive) {
        return this.resolveMap(map, recursive, ResolverUtils::resolveCursor);
    }

    @Override
    public <K> Map<K, Object> resolveCursorProviders(Map<K, Object> map, boolean recursive) {
        return this.resolveMap(map, recursive, this::resolveCursorProvider);
    }

    @Override
    public Object resolveCursor(Object value) {
        return ResolverUtils.resolveCursor(value);
    }

    @Override
    public Object resolveCursorProvider(Object value) {
        if (value instanceof Cursor) {
            return ((Cursor)value).getProvider();
        }
        if (value instanceof InputStream) {
            value = this.resolveCursorStreamProvider((InputStream)value);
        } else if (value instanceof Iterator) {
            value = this.resolveCursorIteratorProvider((Iterator)value);
        }
        return value;
    }

    private Object resolveCursorStreamProvider(InputStream value) {
        CursorProviderFactory factory = this.cursorProviderFactory.accepts(value) ? this.cursorProviderFactory : this.streamingManager.forBytes().getDefaultCursorProviderFactory();
        return factory.of(this.event, value);
    }

    private Object resolveCursorIteratorProvider(Iterator value) {
        CursorProviderFactory factory = this.cursorProviderFactory.accepts(value) ? this.cursorProviderFactory : this.streamingManager.forObjects().getDefaultCursorProviderFactory();
        return factory.of(this.event, value);
    }

    private <K> Map<K, Object> resolveMap(Map<K, Object> map, boolean recursive, Function<Object, Object> valueMapper) {
        Map<K, Map<K, Object>> resolved;
        Preconditions.checkArgument(map != null, "Map cannot be null");
        try {
            resolved = (Map)ClassUtils.instantiateClass(map.getClass(), new Object[0]);
        }
        catch (Exception e) {
            resolved = new LinkedHashMap();
        }
        for (Map.Entry<K, Object> entry : map.entrySet()) {
            Map<K, Object> value = valueMapper.apply(entry.getValue());
            if (recursive && value instanceof Map) {
                value = this.resolveCursors(value, recursive);
            }
            resolved.put(entry.getKey(), value);
        }
        return resolved;
    }
}

