/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.status.StatusLogger;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.launcher.log4j2.LoggerContextCache;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContextFactory;

class ArtifactAwareContextSelector
implements ContextSelector,
Disposable {
    static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final ClassLoader SYSTEM_CLASSLOADER = ClassLoader.getSystemClassLoader();
    private final MuleLoggerContextFactory loggerContextFactory = new MuleLoggerContextFactory();
    private LoggerContextCache cache = new LoggerContextCache(this, this.getClass().getClassLoader());
    private static final Cache<ClassLoader, ClassLoader> classLoaderLoggerCache = CacheBuilder.newBuilder().weakKeys().weakValues().build();

    ArtifactAwareContextSelector() {
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return this.getContext(fqcn, loader, currentContext, null);
    }

    public LoggerContext getContext(String fqcn, ClassLoader classLoader, boolean currentContext, URI configLocation) {
        return this.cache.getLoggerContext(ArtifactAwareContextSelector.resolveLoggerContextClassLoader(classLoader));
    }

    public List<LoggerContext> getLoggerContexts() {
        return this.cache.getAllLoggerContexts();
    }

    public void removeContext(LoggerContext context) {
        this.cache.remove(context);
    }

    static ClassLoader resolveLoggerContextClassLoader(ClassLoader classLoader) {
        if (classLoader == null && Thread.currentThread().getContextClassLoader() == null) {
            return SYSTEM_CLASSLOADER;
        }
        try {
            ClassLoader classLoaderToResolve = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
            ClassLoader loggerClassLoader = (ClassLoader)classLoaderLoggerCache.get((Object)classLoaderToResolve, () -> ArtifactAwareContextSelector.getLoggerClassLoader(classLoaderToResolve));
            return loggerClassLoader;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unable to obtain logger context classLoader for: " + classLoader, e.getCause());
        }
    }

    private static ClassLoader getLoggerClassLoader(ClassLoader loggerClassLoader) {
        while (!(loggerClassLoader instanceof ArtifactClassLoader) && loggerClassLoader != null) {
            loggerClassLoader = loggerClassLoader.getParent();
        }
        if (loggerClassLoader == null) {
            loggerClassLoader = SYSTEM_CLASSLOADER;
        } else if (ArtifactAwareContextSelector.isRegionClassLoaderMember(loggerClassLoader)) {
            loggerClassLoader = ArtifactAwareContextSelector.isPolicyClassLoader(loggerClassLoader.getParent()) ? loggerClassLoader.getParent().getParent() : loggerClassLoader.getParent();
        } else if (!(loggerClassLoader instanceof RegionClassLoader) && !(loggerClassLoader instanceof MuleSharedDomainClassLoader)) {
            loggerClassLoader = SYSTEM_CLASSLOADER;
        }
        return loggerClassLoader;
    }

    private static boolean isPolicyClassLoader(ClassLoader loggerClassLoader) {
        return ((ArtifactClassLoader)((Object)loggerClassLoader)).getArtifactDescriptor() instanceof PolicyTemplateDescriptor;
    }

    private static boolean isRegionClassLoaderMember(ClassLoader classLoader) {
        return !(classLoader instanceof RegionClassLoader) && classLoader.getParent() instanceof RegionClassLoader;
    }

    @Override
    public void dispose() {
        this.cache.dispose();
    }

    public void destroyLoggersFor(ClassLoader classLoader) {
        this.cache.remove(classLoader);
    }

    LoggerContext buildContext(ClassLoader classLoader) {
        return this.loggerContextFactory.build(classLoader, this);
    }
}

