/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.util.List;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceProviderResolutionHelper;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceResolver;
import org.mule.runtime.module.service.internal.discoverer.ServiceResolver;

public class DefaultServiceDiscoverer
implements ServiceDiscoverer {
    private final ServiceResolver serviceResolver;
    private final ServiceProviderDiscoverer serviceProviderDiscoverer;

    public DefaultServiceDiscoverer(ServiceProviderDiscoverer serviceProviderDiscoverer) {
        this(serviceProviderDiscoverer, new ReflectionServiceResolver(new ReflectionServiceProviderResolutionHelper()));
    }

    public DefaultServiceDiscoverer(ServiceProviderDiscoverer serviceProviderDiscoverer, ServiceResolver serviceResolver) {
        Preconditions.checkArgument(serviceProviderDiscoverer != null, "serviceProviderDiscoverer cannot be null");
        Preconditions.checkArgument(serviceResolver != null, "serviceDependencyResolver cannot be null");
        this.serviceResolver = serviceResolver;
        this.serviceProviderDiscoverer = serviceProviderDiscoverer;
    }

    @Override
    public List<Pair<ArtifactClassLoader, Service>> discoverServices() throws ServiceResolutionError {
        List<Pair<ArtifactClassLoader, ServiceProvider>> serviceProviders = this.serviceProviderDiscoverer.discover();
        return this.serviceResolver.resolveServices(serviceProviders);
    }
}

