/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.runtime.module.service.internal.manager.LifecycleFilterServiceProxy;
import org.mule.runtime.module.service.internal.manager.ServiceSplashScreen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleServiceManager
implements ServiceManager {
    private static final Logger logger = LoggerFactory.getLogger(MuleServiceManager.class);
    private final ServiceDiscoverer serviceDiscoverer;
    private List<Pair<ArtifactClassLoader, Service>> registeredServices = new ArrayList<Pair<ArtifactClassLoader, Service>>();
    private List<Service> wrappedServices;

    public MuleServiceManager(ServiceDiscoverer serviceDiscoverer) {
        Preconditions.checkArgument(serviceDiscoverer != null, "serviceDiscoverer cannot be null");
        this.serviceDiscoverer = serviceDiscoverer;
    }

    @Override
    public void start() throws MuleException {
        File servicesFolder = MuleFoldersUtil.getServicesFolder();
        if (!servicesFolder.exists()) {
            servicesFolder.mkdir();
        }
        try {
            this.registeredServices = this.serviceDiscoverer.discoverServices();
            this.wrappedServices = this.wrapServices(this.registeredServices);
            this.startServices();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e, (Startable)this);
        }
    }

    private List<Service> wrapServices(List<Pair<ArtifactClassLoader, Service>> registeredServices) {
        ArrayList<Service> result = new ArrayList<Service>(registeredServices.size());
        for (Pair<ArtifactClassLoader, Service> pair : registeredServices) {
            Service serviceProxy = LifecycleFilterServiceProxy.createLifecycleFilterServiceProxy(pair.getSecond());
            result.add(serviceProxy);
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServices() throws MuleException {
        for (Pair<ArtifactClassLoader, Service> pair : this.registeredServices) {
            Service service = pair.getSecond();
            if (!(service instanceof Startable)) continue;
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(service.getClass().getClassLoader());
                ((Startable)((Object)service)).start();
                if (!StringUtils.isNotEmpty((CharSequence)service.getSplashMessage())) continue;
                logger.info(new ServiceSplashScreen(service).toString());
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
    }

    @Override
    public void stop() throws MuleException {
        for (int i = this.registeredServices.size() - 1; i >= 0; --i) {
            Service service = this.registeredServices.get(i).getSecond();
            if (service instanceof Stoppable) {
                try {
                    ((Stoppable)((Object)service)).stop();
                }
                catch (Exception e) {
                    logger.warn("Service {s} was not stopped properly: {s}", (Object)service.getName(), (Object)e.getMessage());
                }
            }
            try {
                this.registeredServices.get(i).getFirst().dispose();
                continue;
            }
            catch (Exception e) {
                logger.warn("Service {s} class loader was not stopped properly: {s}", (Object)service.getName(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<Service> getServices() {
        return this.wrappedServices;
    }
}

