/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.api.message.dispatcher;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.soap.message.DispatchingRequest;
import org.mule.runtime.extension.api.soap.message.DispatchingResponse;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.soap.api.exception.DispatchingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultHttpMessageDispatcher
implements MessageDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DefaultHttpMessageDispatcher.class.getName());
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    private final HttpClient client;

    public DefaultHttpMessageDispatcher(HttpClient client) {
        this.client = client;
    }

    @Override
    public DispatchingResponse dispatch(DispatchingRequest context) {
        InputStream content = this.logIfNeeded("Soap Request to [" + context.getAddress() + "]", context.getContent());
        MultiMap<String, String> parameters = new MultiMap<String, String>();
        context.getHeaders().forEach(parameters::put);
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(context.getAddress()).method(HttpConstants.Method.POST).entity(new InputStreamHttpEntity(content))).headers(parameters)).build();
        try {
            HttpResponse response = this.client.send(request, 5000, false, null);
            return new DispatchingResponse(this.logIfNeeded("Soap Response", response.getEntity().getContent()), this.toHeadersMap(response));
        }
        catch (IOException e) {
            throw new DispatchingException("An error occurred while sending the SOAP request");
        }
        catch (TimeoutException e) {
            throw new DispatchingException("The SOAP request timed out", (Throwable)e);
        }
    }

    private InputStream logIfNeeded(String title, InputStream content) {
        if (LOGGER.isDebugEnabled()) {
            String c = IOUtils.toString(content);
            LOGGER.debug("Logging " + title);
            LOGGER.debug("-----------------------------------");
            LOGGER.debug(c);
            LOGGER.debug("-----------------------------------");
            return new ByteArrayInputStream(c.getBytes());
        }
        return content;
    }

    private Map<String, String> toHeadersMap(HttpResponse response) {
        return response.getHeaderNames().stream().collect(Collectors.toMap(Function.identity(), name -> response.getHeaderValues((String)name).stream().collect(Collectors.joining(" "))));
    }
}

