/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service;

import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.grizzly.CloseReason;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.mule.service.http.impl.service.server.ContextHttpServerFactoryAdapter;
import org.mule.service.http.impl.service.server.HttpListenerConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceImplementation
implements HttpService,
Startable,
Stoppable {
    private static final Logger logger;
    private static final String CONTAINER_CONTEXT = "container";
    protected final SchedulerService schedulerService;
    private HttpListenerConnectionManager connectionManager;

    public HttpServiceImplementation(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
        this.connectionManager = new HttpListenerConnectionManager(schedulerService, SchedulerConfig.config());
    }

    @Override
    public HttpServerFactory getServerFactory() {
        return new ContextHttpServerFactoryAdapter(CONTAINER_CONTEXT, this.connectionManager);
    }

    @Inject
    public HttpServerFactory getServerFactory(@Named(value="_muleContext") MuleContext muleContext) {
        return new ContextHttpServerFactoryAdapter(muleContext.getId(), this.connectionManager);
    }

    @Override
    public HttpClientFactory getClientFactory() {
        return config -> new GrizzlyHttpClient(config, this.schedulerService, SchedulerConfig.config());
    }

    @Inject
    public HttpClientFactory getClientFactory(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig schedulersConfig) {
        return config -> new GrizzlyHttpClient(config, this.schedulerService, schedulersConfig);
    }

    @Override
    public String getName() {
        return "HTTP Service";
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.initialiseIfNeeded(this.connectionManager);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.disposeIfNeeded(this.connectionManager, logger);
    }

    static {
        CloseReason locallyClosedReason = CloseReason.LOCALLY_CLOSED_REASON;
        CloseReason closeReason = CloseReason.REMOTELY_CLOSED_REASON;
        logger = LoggerFactory.getLogger(HttpServiceImplementation.class);
    }
}

