/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.mule.weave.v2.interpreted.DefaultModuleNodeLoader;
import org.mule.weave.v2.interpreted.InterpretedMappingExecutableWeave;
import org.mule.weave.v2.interpreted.InterpretedModuleExecutableWeave;
import org.mule.weave.v2.interpreted.InterpreterMappingCompilerPhase;
import org.mule.weave.v2.interpreted.InterpreterModuleCompilerPhase;
import org.mule.weave.v2.interpreted.debugger.server.DefaultWeaveDebuggingSession;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerDebuggerProtocol;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerDebuggerProtocol$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.EvaluationContext$;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.module.reader.Reader;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.AstNodeResultAware;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.parser.phase.TypeCheckingResult;
import org.mule.weave.v2.runtime.CompilationResult;
import org.mule.weave.v2.runtime.ExecutableWeave;
import org.mule.weave.v2.runtime.ExecutableWeaveHelper$;
import org.mule.weave.v2.runtime.utils.WeaveRunner;
import org.mule.weave.v2.sdk.ParsingContextFactory$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.ts.WeaveType;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WeaveRunner$
implements App {
    public static WeaveRunner$ MODULE$;
    private OutputStream output;
    private Seq<Tuple2<String, File>> inputs;
    private Seq<String> parameters;
    private boolean debug;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new WeaveRunner$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public OutputStream output() {
        return this.output;
    }

    public void output_$eq(OutputStream x$1) {
        this.output = x$1;
    }

    public Seq<Tuple2<String, File>> inputs() {
        return this.inputs;
    }

    public void inputs_$eq(Seq<Tuple2<String, File>> x$1) {
        this.inputs = x$1;
    }

    public Seq<String> parameters() {
        return this.parameters;
    }

    public void parameters_$eq(Seq<String> x$1) {
        this.parameters = x$1;
    }

    public boolean debug() {
        return this.debug;
    }

    public void debug_$eq(boolean x$1) {
        this.debug = x$1;
    }

    public void main() {
        EvaluationContext ctx = EvaluationContext$.MODULE$.apply();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).isEmpty()) {
            System.err.println("Data Weave File was not specified.");
            this.usage();
        } else {
            File file = new File((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).last());
            if (!file.exists()) {
                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data Weave File does not exists ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                this.usage();
            } else {
                String[] configArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).slice(0, this.args().length - 1);
                for (int index = 0; index < configArgs.length; ++index) {
                    BoxedUnit boxedUnit;
                    String string = configArgs[index];
                    if ("-input".equals(string)) {
                        String inputName;
                        File input;
                        if (index + 2 < configArgs.length) {
                            input = new File(configArgs[index + 2]);
                            inputName = configArgs[index + 1];
                            if (!input.exists()) {
                                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input file ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputName, input.getAbsolutePath()})));
                                this.usage();
                                return;
                            }
                        } else {
                            System.err.println("Invalid amount of arguments on input.");
                            this.usage();
                            return;
                        }
                        this.inputs_$eq((Seq<Tuple2<String, File>>)((Seq)this.inputs().$colon$plus((Object)new Tuple2((Object)inputName, (Object)input), Seq$.MODULE$.canBuildFrom())));
                        index += 2;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boolean bl = "-param".equals(string) ? true : "-p".equals(string);
                    if (bl) {
                        if (index + 1 >= configArgs.length) {
                            System.err.println("Invalid amount of arguments on param.");
                            this.usage();
                            return;
                        }
                        String paramValue = configArgs[index + 1];
                        this.parameters_$eq((Seq<String>)((Seq)this.parameters().$colon$plus((Object)paramValue, Seq$.MODULE$.canBuildFrom())));
                        index += 2;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if ("-output".equals(string)) {
                        if (index + 1 >= configArgs.length) {
                            System.err.println("Invalid amount of arguments on output.");
                            this.usage();
                            return;
                        }
                        this.output_$eq(new FileOutputStream(new File(configArgs[index + 1])));
                        ++index;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if ("-debug".equals(string)) {
                        this.debug_$eq(true);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid argument ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                    this.usage();
                    return;
                }
            }
            this.execute(file, ctx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(File file, EvaluationContext ctx) {
        DocumentParser documentParser = new DocumentParser(0);
        WeaveResource resource = WeaveResourceFactory$.MODULE$.fromFile(file);
        String filePath = file.getPath();
        String basePath = new File(".").getAbsolutePath();
        String path = filePath;
        if (filePath.startsWith(basePath)) {
            path = filePath.substring(basePath.length());
        }
        path = path.substring(0, path.lastIndexOf(46));
        ParsingContext parsingContext = ParsingContextFactory$.MODULE$.createParsingContext(NameIdentifier$.MODULE$.fromElements(path.split(File.separator)));
        this.inputs().foreach((Function1 & Serializable & scala.Serializable)input -> parsingContext.addImplicitInput((String)input._1(), (Option<WeaveType>)None$.MODULE$));
        PhaseResult<ParsingResult<AstNode>> parse = documentParser.parse(resource, parsingContext);
        PhaseResult<TypeCheckingResult<? extends AstNode>> typeCheckResult = documentParser.typeCheck(documentParser.scopeCheck(documentParser.canonical(parse, parsingContext), parsingContext), parsingContext);
        if (typeCheckResult.hasResult()) {
            TypeCheckingResult<? extends AstNode> result = typeCheckResult.getResult();
            Object t = result.astNode();
            if (t instanceof DocumentNode) {
                BoxedUnit boxedUnit;
                TypeCheckingResult<? extends AstNode> value = typeCheckResult.getResult();
                PhaseResult<CompilationResult<DocumentNode>> result2 = new InterpreterMappingCompilerPhase(new DefaultModuleNodeLoader()).call((AstNodeResultAware<DocumentNode>)value, parsingContext);
                ExecutableWeave<DocumentNode> engine = result2.getResult().executable();
                if (this.debug()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    TcpServerDebuggerProtocol protocol = TcpServerDebuggerProtocol$.MODULE$.apply(TcpServerDebuggerProtocol$.MODULE$.apply$default$1());
                    DefaultWeaveDebuggingSession debuggingSession = ((InterpretedMappingExecutableWeave)engine).debug(protocol);
                    debuggingSession.addSessionListener(() -> new Thread(ctx, engine, latch, protocol){
                        private final EvaluationContext ctx$1;
                        private final ExecutableWeave engine$1;
                        private final CountDownLatch latch$1;
                        private final TcpServerDebuggerProtocol protocol$1;

                        public void run() {
                            this.engine$1.write(ExecutableWeaveHelper$.MODULE$.buildWriter(this.engine$1, WeaveRunner$.MODULE$.output()), ExecutableWeaveHelper$.MODULE$.buildReaders(this.engine$1, (Map<String, Object>)WeaveRunner$.MODULE$.inputs().toMap(Predef$.MODULE$.$conforms()), this.ctx$1), this.engine$1.write$default$3(), this.ctx$1);
                            this.protocol$1.disconnect();
                            this.latch$1.countDown();
                        }
                        {
                            this.ctx$1 = ctx$1;
                            this.engine$1 = engine$1;
                            this.latch$1 = latch$1;
                            this.protocol$1 = protocol$1;
                        }
                    }.start());
                    Predef$.MODULE$.println((Object)"Waiting for debugger client to connect.");
                    latch.await();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    engine.write(ExecutableWeaveHelper$.MODULE$.buildWriter(engine, this.output()), ExecutableWeaveHelper$.MODULE$.buildReaders(engine, (Map<String, Object>)this.inputs().toMap(Predef$.MODULE$.$conforms()), ctx), engine.write$default$3(), ctx);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            } else {
                BoxedUnit boxedUnit;
                if (!(t instanceof ModuleNode)) throw new MatchError(t);
                Map values = ((TraversableOnce)((TraversableLike)this.parameters().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)valueIndex -> new Tuple2((Object)((Object)BoxesRunTime.boxToInteger((int)valueIndex._2$mcI$sp())).toString(), (Object)StringValue$.MODULE$.apply((String)valueIndex._1())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                TypeCheckingResult<? extends AstNode> value = typeCheckResult.getResult();
                PhaseResult<? extends CompilationResult<ModuleNode>> result3 = new InterpreterModuleCompilerPhase(new DefaultModuleNodeLoader()).call((AstNodeResultAware<ModuleNode>)value, parsingContext);
                ExecutableWeave<ModuleNode> engine = result3.getResult().executable();
                if (this.debug()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    TcpServerDebuggerProtocol protocol = TcpServerDebuggerProtocol$.MODULE$.apply(TcpServerDebuggerProtocol$.MODULE$.apply$default$1());
                    DefaultWeaveDebuggingSession debuggingSession = ((InterpretedModuleExecutableWeave)engine).debug(protocol);
                    debuggingSession.addSessionListener(() -> new Thread(ctx, values, engine, latch, protocol){
                        private final EvaluationContext ctx$1;
                        private final Map values$1;
                        private final ExecutableWeave engine$2;
                        private final CountDownLatch latch$2;
                        private final TcpServerDebuggerProtocol protocol$2;

                        public void run() {
                            Map x$1 = this.values$1;
                            Map<String, Reader> x$2 = this.engine$2.execute$default$1();
                            this.engine$2.execute(x$2, x$1, this.ctx$1);
                            this.protocol$2.disconnect();
                            this.latch$2.countDown();
                        }
                        {
                            this.ctx$1 = ctx$1;
                            this.values$1 = values$1;
                            this.engine$2 = engine$2;
                            this.latch$2 = latch$2;
                            this.protocol$2 = protocol$2;
                        }
                    }.start());
                    Predef$.MODULE$.println((Object)"Waiting for debugger client to connect.");
                    latch.await();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Map x$3 = values;
                    Map<String, Reader> x$4 = engine.execute$default$1();
                    engine.execute(x$4, x$3, ctx);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            }
            return;
        } else {
            typeCheckResult.errorMessages().foreach((Function1 & Serializable & scala.Serializable)message -> {
                Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Error] ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Message)message._2()).message()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" {", ":", "}:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().line()), BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().column()), ((WeaveLocation)message._1()).locationString()}))));
                return BoxedUnit.UNIT;
            });
            typeCheckResult.warningMessages().foreach((Function1 & Serializable & scala.Serializable)message -> {
                Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Warning] ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Message)message._2()).message()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" {", ":", "}:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().line()), BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().column()), ((WeaveLocation)message._1()).locationString()}))));
                return BoxedUnit.UNIT;
            });
            if (!typeCheckResult.hasErrors() && !typeCheckResult.isEmpty()) return;
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Errors where found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)typeCheckResult.errorMessages().size())})));
            System.exit(1);
            return;
        }
    }

    public void usage() {
        Predef$.MODULE$.println((Object)"weave [-input <name> <value>]* [-param | -p <paramValue>]* [-debug]? [-output <path>]? <weave file path>");
    }

    public final void delayedEndpoint$org$mule$weave$v2$runtime$utils$WeaveRunner$1() {
        this.output = System.out;
        this.inputs = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.parameters = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.debug = false;
        this.main();
    }

    private WeaveRunner$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new WeaveRunner.delayedInit.body(this));
    }
}

