/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.mule.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.mule.apache.xerces.impl.dv.ValidationContext;
import org.mule.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.mule.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDayDV
extends AbstractDateTimeDV {
    private static final int MONTHDAY_SIZE = 7;

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content, context.getTypeValidatorHelper().isXMLSchema11());
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gMonthDay"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str, boolean isXMLSchema11) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date = new AbstractDateTimeDV.DateTimeData(str, this);
        int len = str.length();
        date.year = 2000;
        if (str.charAt(0) != '-' || str.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + str);
        }
        date.month = this.parseInt(str, 2, 4);
        int start = 4;
        if (str.charAt(start++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + str);
        }
        date.day = this.parseInt(str, start, start + 2);
        if (7 < len) {
            if (!this.isNextCharUTCSign(str, 7, len)) {
                throw new SchemaDateTimeException("Error in month parsing:" + str);
            }
            this.getTimeZone(str, date, 7, len);
        }
        this.validateDateTime(date, isXMLSchema11);
        this.saveUnnormalized(date);
        if (date.utc != 0 && date.utc != 90) {
            this.normalize(date);
        }
        date.position = 1;
        return date;
    }

    @Override
    protected String dateToString(AbstractDateTimeDV.DateTimeData date) {
        StringBuffer message = new StringBuffer(8);
        message.append('-');
        message.append('-');
        this.append(message, date.month, 2);
        message.append('-');
        this.append(message, date.day, 2);
        this.append(message, (char)date.utc, 0);
        return message.toString();
    }

    @Override
    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData date) {
        return datatypeFactory.newXMLGregorianCalendar(Integer.MIN_VALUE, date.unNormMonth, date.unNormDay, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, date.hasTimeZone() ? date.timezoneHr * 60 + date.timezoneMin : Integer.MIN_VALUE);
    }
}

