/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.mule.maven.client.api.BadMavenConfigurationException;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.RemoteRepositoriesMerger;
import org.mule.maven.client.internal.util.MavenModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherResolutionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherResolutionContext.class);
    private List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private File localRepositoryLocation;
    private Optional<AuthenticationSelector> authenticationSelector = Optional.empty();
    private Optional<ProxySelector> proxySelector = Optional.empty();
    private Optional<MirrorSelector> mirrorSelector = Optional.empty();

    public AetherResolutionContext(MavenConfiguration mavenConfiguration) {
        this.resolveMavenConfiguration(mavenConfiguration);
    }

    public File getLocalRepositoryLocation() {
        return this.localRepositoryLocation;
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return Lists.newArrayList(this.remoteRepositories);
    }

    private void resolveMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.localRepositoryLocation = mavenConfiguration.getLocalMavenRepositoryLocation();
        Optional<Settings> mavenSettingsOptional = this.getMavenSettings(mavenConfiguration.getUserSettingsLocation(), mavenConfiguration.getGlobalSettingsLocation());
        mavenSettingsOptional.ifPresent(mavenSettings -> {
            this.createAuthenticatorSelector(mavenConfiguration, (Settings)mavenSettings);
            this.createProxySelector((Settings)mavenSettings);
            this.createMirrorSelector((Settings)mavenSettings);
        });
        this.remoteRepositories = this.collectRepositoriesFromConfiguration(mavenConfiguration, this.authenticationSelector, this.proxySelector, this.mirrorSelector);
        mavenSettingsOptional.ifPresent(mavenSettings -> {
            LOGGER.debug("Configuring optional Maven settings...");
            this.addRepositoriesFromMavenConfig(mavenConfiguration, (Settings)mavenSettings, this.authenticationSelector, this.proxySelector, this.mirrorSelector);
            String localRepository = mavenSettings.getLocalRepository();
            if (this.localRepositoryLocation == null && localRepository != null) {
                File localRepositoryFile = new File(localRepository);
                if (!localRepositoryFile.isDirectory() || !localRepositoryFile.exists()) {
                    throw new BadMavenConfigurationException(String.format("Local repository location %s resolved from maven settings file does not exists or is not a directory", localRepository));
                }
                this.localRepositoryLocation = localRepositoryFile;
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using {}", (Object)this.toString());
        }
    }

    private List<RemoteRepository> collectRepositoriesFromConfiguration(MavenConfiguration mavenConfiguration, Optional<AuthenticationSelector> authenticationSelectorOptional, Optional<ProxySelector> proxySelectorOptional, Optional<MirrorSelector> mirrorSelector) {
        ImmutableList.Builder collectedRepositories = ImmutableList.builder();
        List<org.mule.maven.client.api.model.RemoteRepository> clientConfiguredRepositories = mavenConfiguration.getMavenRemoteRepositories();
        clientConfiguredRepositories.stream().forEachOrdered(remoteRepoConfig -> {
            RemoteRepository.Builder aetherRepoBuilder = new RemoteRepository.Builder(remoteRepoConfig.getId(), "default", remoteRepoConfig.getUrl().toString());
            if (remoteRepoConfig.getAuthentication().isPresent()) {
                org.mule.maven.client.api.model.Authentication authentication = remoteRepoConfig.getAuthentication().get();
                aetherRepoBuilder.setAuthentication(new AuthenticationBuilder().addUsername(authentication.getUsername()).addPassword(authentication.getPassword()).build());
            }
            aetherRepoBuilder = this.processRemoteRepository(mavenConfiguration, authenticationSelectorOptional, proxySelectorOptional, mirrorSelector, aetherRepoBuilder);
            if (mavenConfiguration.getForcePolicyUpdateNever()) {
                aetherRepoBuilder.setSnapshotPolicy(new RepositoryPolicy(true, "never", "ignore"));
                aetherRepoBuilder.setReleasePolicy(new RepositoryPolicy(true, "never", "fail"));
            }
            collectedRepositories.add((Object)aetherRepoBuilder.build());
        });
        return collectedRepositories.build();
    }

    private RemoteRepository.Builder selectAuthenticator(RemoteRepository.Builder aetherRepoBuilder, Optional<AuthenticationSelector> authenticationSelectorOptional) {
        if (authenticationSelectorOptional.isPresent()) {
            RemoteRepository prototypeRepository = aetherRepoBuilder.build();
            Authentication authentication = authenticationSelectorOptional.get().getAuthentication(prototypeRepository);
            if (authentication != null) {
                aetherRepoBuilder = new RemoteRepository.Builder(prototypeRepository);
                aetherRepoBuilder.setAuthentication(authentication);
            }
        }
        return aetherRepoBuilder;
    }

    private void addRepositoriesFromMavenConfig(MavenConfiguration mavenConfiguration, Settings mavenSettings, Optional<AuthenticationSelector> authenticationSelectorOptional, Optional<ProxySelector> proxySelectorOptional, Optional<MirrorSelector> mirrorSelectorOptional) {
        List profiles = mavenSettings.getProfiles().stream().map(MavenModelUtils::toModelProfile).collect(Collectors.toList());
        List activeProfiles = MavenModelUtils.getProfileSelector().getActiveProfiles(profiles, MavenModelUtils.getProfileActivationContext(mavenSettings), MavenModelUtils.getModelProblemCollector()).stream().map(profile -> profile.getId()).collect(Collectors.toList());
        ImmutableList.Builder remoteRepositoriesFromSettings = ImmutableList.builder();
        for (String profileName : mavenSettings.getProfilesAsMap().keySet()) {
            Profile profile2 = (Profile)mavenSettings.getProfilesAsMap().get(profileName);
            if (!mavenSettings.getActiveProfiles().contains(profileName) && !Optional.ofNullable(profile2.getActivation()).map(Activation::isActiveByDefault).orElse(true).booleanValue() && !activeProfiles.contains(profileName)) continue;
            List repositories = profile2.getRepositories();
            for (Repository repo : repositories) {
                RemoteRepository.Builder remoteRepo = new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl());
                remoteRepo = this.processRemoteRepository(mavenConfiguration, authenticationSelectorOptional, proxySelectorOptional, mirrorSelectorOptional, remoteRepo);
                if (mavenConfiguration.getForcePolicyUpdateNever()) {
                    remoteRepo.setSnapshotPolicy(new RepositoryPolicy(true, "never", "ignore"));
                    remoteRepo.setReleasePolicy(new RepositoryPolicy(true, "never", "fail"));
                } else {
                    if (repo.getSnapshots() != null) {
                        remoteRepo.setSnapshotPolicy(new RepositoryPolicy(repo.getSnapshots().isEnabled(), repo.getSnapshots().getUpdatePolicy(), repo.getSnapshots().getChecksumPolicy()));
                    }
                    if (repo.getReleases() != null) {
                        remoteRepo.setReleasePolicy(new RepositoryPolicy(repo.getReleases().isEnabled(), repo.getReleases().getUpdatePolicy(), repo.getReleases().getChecksumPolicy()));
                    }
                }
                remoteRepositoriesFromSettings.add((Object)remoteRepo.build());
            }
        }
        this.remoteRepositories = new RemoteRepositoriesMerger().merge(this.remoteRepositories, (List<RemoteRepository>)remoteRepositoriesFromSettings.build());
    }

    private RemoteRepository.Builder processRemoteRepository(MavenConfiguration mavenConfiguration, Optional<AuthenticationSelector> authenticationSelectorOptional, Optional<ProxySelector> proxySelectorOptional, Optional<MirrorSelector> mirrorSelectorOptional, RemoteRepository.Builder aetherRepoBuilder) {
        RemoteRepository prototypeRepository;
        aetherRepoBuilder = this.selectAuthenticator(aetherRepoBuilder, authenticationSelectorOptional);
        if (proxySelectorOptional.isPresent()) {
            prototypeRepository = aetherRepoBuilder.build();
            Proxy proxy = proxySelectorOptional.get().getProxy(prototypeRepository);
            if (proxy != null) {
                aetherRepoBuilder = new RemoteRepository.Builder(prototypeRepository);
                aetherRepoBuilder.setProxy(proxy);
            }
        }
        if (mirrorSelectorOptional.isPresent()) {
            prototypeRepository = aetherRepoBuilder.build();
            RemoteRepository mirror = mirrorSelectorOptional.get().getMirror(prototypeRepository);
            if (mirror != null) {
                aetherRepoBuilder = new RemoteRepository.Builder(mirror);
                aetherRepoBuilder = this.selectAuthenticator(aetherRepoBuilder, authenticationSelectorOptional);
            }
        }
        if (mavenConfiguration.getForcePolicyUpdateNever()) {
            aetherRepoBuilder.setSnapshotPolicy(new RepositoryPolicy(true, "never", "ignore"));
            aetherRepoBuilder.setReleasePolicy(new RepositoryPolicy(true, "never", "fail"));
        }
        return aetherRepoBuilder;
    }

    private void createAuthenticatorSelector(MavenConfiguration mavenConfiguration, Settings mavenSettings) {
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        mavenSettings.getServers().stream().forEach(server -> defaultAuthenticationSelector.add(server.getId(), new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build()));
        mavenConfiguration.getMavenRemoteRepositories().stream().filter(remoteRepository -> remoteRepository.getAuthentication().isPresent()).forEach(remoteRepository -> defaultAuthenticationSelector.add(remoteRepository.getId(), new AuthenticationBuilder().addUsername(remoteRepository.getAuthentication().get().getUsername()).addPassword(remoteRepository.getAuthentication().get().getPassword()).build()));
        this.authenticationSelector = Optional.of(defaultAuthenticationSelector);
    }

    private void createProxySelector(Settings mavenSettings) {
        DefaultProxySelector defaultProxySelector = new DefaultProxySelector();
        mavenSettings.getProxies().stream().filter(proxy -> proxy.isActive()).forEach(proxy -> defaultProxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build()), proxy.getNonProxyHosts()));
        this.proxySelector = Optional.of(defaultProxySelector);
    }

    private void createMirrorSelector(Settings mavenSettings) {
        DefaultMirrorSelector defaultMirrorSelector = new DefaultMirrorSelector();
        mavenSettings.getMirrors().stream().forEachOrdered(mirror -> defaultMirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts()));
        this.mirrorSelector = Optional.of(defaultMirrorSelector);
    }

    private Optional<Settings> getMavenSettings(Optional<File> userSettingsFile, Optional<File> globalSettingsFile) {
        if (!userSettingsFile.isPresent() && !globalSettingsFile.isPresent()) {
            return Optional.empty();
        }
        try {
            DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
            settingsBuildingRequest.setSystemProperties(System.getProperties());
            userSettingsFile.ifPresent(arg_0 -> ((SettingsBuildingRequest)settingsBuildingRequest).setUserSettingsFile(arg_0));
            globalSettingsFile.ifPresent(arg_0 -> ((SettingsBuildingRequest)settingsBuildingRequest).setGlobalSettingsFile(arg_0));
            DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
            DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
            SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
            return Optional.of(settingsBuildingResult.getEffectiveSettings());
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<AuthenticationSelector> getAuthenticatorSelector() {
        return this.authenticationSelector;
    }

    public Optional<ProxySelector> getProxySelector() {
        return this.proxySelector;
    }

    public Optional<MirrorSelector> getMirrorSelector() {
        return this.mirrorSelector;
    }

    public String toString() {
        return "AetherResolutionContext{remoteRepositories=" + this.repositoriesToString() + ", localMavenRepositoryLocation=" + this.localRepositoryLocation.getAbsolutePath() + '}';
    }

    private String repositoriesToString() {
        return String.join((CharSequence)",\n", this.remoteRepositories.stream().map(RemoteRepository::toString).collect(Collectors.toList()));
    }
}

