/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.example;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.json.api.example.HandlerManager;
import org.mule.metadata.json.api.example.JsonElementHandler;
import org.mule.metadata.json.api.example.ParsingContext;

public class ArrayHandler
implements JsonElementHandler {
    @Override
    public boolean handles(JsonElement jsonElement) {
        return jsonElement.isJsonArray();
    }

    @Override
    public TypeBuilder<?> handle(JsonElement jsonElement, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        JsonArray array = (JsonArray)jsonElement;
        ArrayTypeBuilder arrayMetadataBuilder = root.arrayType();
        parsingContext.getAnnotations().forEach(arrayMetadataBuilder::with);
        JsonElement arraySample = this.getFirstChild(array);
        if (arraySample != null) {
            ArrayList uniqueTypes = new ArrayList();
            LinkedHashMap builders = new LinkedHashMap();
            for (JsonElement item : array) {
                TypeBuilder<?> itemBuilder = handlerManager.handle(item, new ParsingContext());
                Object type = itemBuilder.build();
                if (builders.containsKey(type)) continue;
                builders.put(type, itemBuilder);
            }
            if (builders.size() > 1) {
                UnionTypeBuilder unionTypeBuilder = arrayMetadataBuilder.of().unionType();
                builders.values().forEach(unionTypeBuilder::of);
            } else {
                arrayMetadataBuilder.of(handlerManager.handle(arraySample, new ParsingContext()));
            }
        } else {
            arrayMetadataBuilder.of().anyType();
        }
        return arrayMetadataBuilder;
    }

    private JsonElement getFirstChild(JsonArray array) {
        Iterator i = array.iterator();
        if (i.hasNext()) {
            return (JsonElement)i.next();
        }
        return null;
    }
}

