/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.NotifierCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender<N extends Notification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sender.class);
    private ListenerSubscriptionPair<N> pair;

    Sender(ListenerSubscriptionPair<N> pair) {
        this.pair = pair;
    }

    public void dispatch(N notification, NotifierCallback notifier) {
        if (this.pair.getSelector().test(notification)) {
            try {
                notifier.notify(this.pair.getListener(), (Notification)notification);
            }
            catch (Throwable e) {
                LOGGER.info("NotificationListener {} was unable to fire notification {} due to an exception: {}.", new Object[]{this.pair.getListener(), notification, e});
            }
        }
    }
}

