/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.internal.exception.CompositeErrorTypeRepository;
import org.mule.runtime.core.internal.exception.DefaultErrorTypeRepository;

public class ErrorTypeRepositoryFactory {
    public static ErrorTypeRepository createDefaultErrorTypeRepository() {
        DefaultErrorTypeRepository errorTypeRepository = new DefaultErrorTypeRepository();
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.TRANSFORMATION, errorTypeRepository.getAnyErrorType());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.EXPRESSION, errorTypeRepository.getAnyErrorType());
        ErrorType validationErrorType = errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.VALIDATION, errorTypeRepository.getAnyErrorType());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.DUPLICATE_MESSAGE, validationErrorType);
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED, errorTypeRepository.getAnyErrorType());
        ErrorType connectivityErrorType = errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY, errorTypeRepository.getAnyErrorType());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.RETRY_EXHAUSTED, connectivityErrorType);
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.ROUTING, errorTypeRepository.getAnyErrorType());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY, errorTypeRepository.getAnyErrorType());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.CLIENT_SECURITY, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY).get());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY).get());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.NOT_PERMITTED, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY).get());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.STREAM_MAXIMUM_SIZE_EXCEEDED, errorTypeRepository.getAnyErrorType());
        errorTypeRepository.addInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD, errorTypeRepository.getCriticalErrorType());
        errorTypeRepository.addInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).get());
        errorTypeRepository.addInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.FATAL, errorTypeRepository.getCriticalErrorType());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.TIMEOUT, errorTypeRepository.getAnyErrorType());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.COMPOSITE_ROUTING, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.ROUTING).get());
        ErrorType sourceErrorType = errorTypeRepository.getSourceErrorType();
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE, errorTypeRepository.getSourceResponseErrorType());
        errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND, errorTypeRepository.getSourceResponseErrorType());
        errorTypeRepository.addInternalErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE, sourceErrorType);
        errorTypeRepository.addInternalErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND, sourceErrorType);
        return errorTypeRepository;
    }

    public static ErrorTypeRepository createCompositeErrorTypeRepository(ErrorTypeRepository parentErrorTypeRepository) {
        Preconditions.checkNotNull(parentErrorTypeRepository, "'parentErrorTypeRepository' can't be null");
        return new CompositeErrorTypeRepository(ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository(), parentErrorTypeRepository);
    }
}

