/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptionAction;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAroundInterceptorAdapter
extends ReactiveInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveAroundInterceptorAdapter.class);
    private static final String AROUND_METHOD_NAME = "around";

    public ReactiveAroundInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        super(interceptorFactory);
    }

    @Override
    protected ReactiveProcessor doApply(Processor component, ReactiveProcessor next, ComponentLocation componentLocation, ProcessorInterceptor interceptor, Map<String, String> dslParameters) {
        if (this.implementsAround(interceptor)) {
            LOGGER.debug("Configuring interceptor '{}' around processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            return publisher -> Flux.from(publisher).cast(InternalEvent.class).flatMap(event -> Mono.fromFuture(this.doAround((InternalEvent)event, interceptor, component, dslParameters, next)).onErrorMap(CompletionException.class, completionException -> completionException.getCause()));
        }
        return next;
    }

    private boolean implementsAround(ProcessorInterceptor interceptor) {
        try {
            return !interceptor.getClass().getMethod(AROUND_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class, InterceptionAction.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private CompletableFuture<InternalEvent> doAround(InternalEvent event, ProcessorInterceptor interceptor, Processor component, Map<String, String> dslParameters, ReactiveProcessor next) {
        InternalEvent eventWithResolvedParams = this.addResolvedParameters(event, component, dslParameters);
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
        ReactiveInterceptionAction reactiveInterceptionAction = new ReactiveInterceptionAction(interceptionEvent, next, component, ((PrivilegedMuleContext)this.getMuleContext()).getErrorTypeLocator());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling around() for '{}' in processor '{}'...", (Object)interceptor, (Object)((Component)((Object)component)).getLocation().getLocation());
        }
        try {
            return ((CompletableFuture)ClassUtils.withContextClassLoader(interceptor.getClass().getClassLoader(), () -> interceptor.around(((Component)((Object)component)).getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent, reactiveInterceptionAction)).exceptionally(t -> {
                if (t instanceof MessagingException) {
                    throw new CompletionException((Throwable)t);
                }
                throw new CompletionException(this.createMessagingException(eventWithResolvedParams, t instanceof CompletionException ? t.getCause() : t, (Component)((Object)component)));
            })).thenApply(interceptedEvent -> interceptedEvent != null ? ((DefaultInterceptionEvent)interceptedEvent).resolve() : null);
        }
        catch (Exception e) {
            throw Exceptions.propagate(this.createMessagingException(interceptionEvent.resolve(), e, (Component)((Object)component)));
        }
    }
}

