/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.OptimizedCaseInsensitiveMapWrapper;

@NoExtend
public class CaseInsensitiveMultiMap
extends MultiMap<String, String> {
    private static final long serialVersionUID = -3754163327838153655L;
    protected final boolean optimized;

    public CaseInsensitiveMultiMap() {
        this(new MultiMap<String, String>());
    }

    public CaseInsensitiveMultiMap(boolean optimized) {
        this(new MultiMap<String, String>(), optimized);
    }

    public CaseInsensitiveMultiMap(MultiMap<String, String> paramsMap) {
        this(paramsMap, true);
    }

    public CaseInsensitiveMultiMap(MultiMap<String, String> paramsMap, boolean optimized) {
        this.optimized = optimized;
        this.paramsMap = optimized ? new OptimizedCaseInsensitiveMapWrapper(new LinkedHashMap()) : new CaseInsensitiveMapWrapper(new LinkedHashMap());
        for (String key : paramsMap.keySet()) {
            this.paramsMap.put(key, paramsMap.getAll(key).stream().collect(Collectors.toCollection(LinkedList::new)));
        }
    }

    public CaseInsensitiveMultiMap toImmutableMultiMap() {
        if (this instanceof ImmutableCaseInsensitiveMultiMap) {
            return this;
        }
        return new ImmutableCaseInsensitiveMultiMap(this);
    }

    private static class ImmutableCaseInsensitiveMultiMap
    extends CaseInsensitiveMultiMap {
        private static final long serialVersionUID = -1048913048598100657L;

        public ImmutableCaseInsensitiveMultiMap(CaseInsensitiveMultiMap caseInsensitiveMultiMap) {
            super(caseInsensitiveMultiMap, caseInsensitiveMultiMap.optimized);
            this.paramsMap = Collections.unmodifiableMap(this.paramsMap);
        }
    }
}

