/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.TypedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOutputDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.core.internal.metadata.DefaultMetadataResolverFactory;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverFactory;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart;
import org.mule.runtime.extension.api.annotation.param.Query;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.metadata.MetadataScopeAdapter;
import org.mule.runtime.module.extension.internal.metadata.QueryMetadataResolverFactory;

public class DynamicMetadataDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private String getCategoryName(Supplier<? extends TypeKeysResolver> keysResolver) {
        TypeKeysResolver typeKeysResolver = keysResolver.get();
        return typeKeysResolver instanceof NullMetadataResolver ? null : typeKeysResolver.getCategoryName();
    }

    private class EnricherDelegate
    extends AbstractAnnotatedDeclarationEnricher {
        private Type extensionType;
        private NullMetadataResolver nullMetadataResolver = new NullMetadataResolver();

        private EnricherDelegate() {
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            Optional<ExtensionTypeDescriptorModelProperty> property = ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getModelProperty(ExtensionTypeDescriptorModelProperty.class);
            if (property.isPresent() && property.get().getType().getDeclaringClass().isPresent()) {
                this.extensionType = property.get().getType();
                new IdempotentDeclarationWalker(){

                    @Override
                    public void onSource(SourceDeclaration declaration) {
                        EnricherDelegate.this.enrichSourceMetadata(declaration);
                    }

                    @Override
                    public void onOperation(OperationDeclaration declaration) {
                        EnricherDelegate.this.enrichOperationMetadata(declaration);
                    }
                }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
            }
        }

        private void enrichSourceMetadata(SourceDeclaration declaration) {
            declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class).ifPresent(prop -> {
                Type sourceType = prop.getType();
                MetadataScopeAdapter metadataScope = new MetadataScopeAdapter(this.extensionType, sourceType, declaration);
                this.declareMetadataResolverFactory(declaration, metadataScope);
                this.enrichMetadataKeyParameters(declaration, metadataScope.getKeysResolver().get());
            });
        }

        private void enrichOperationMetadata(OperationDeclaration declaration) {
            declaration.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(ExtensionOperationDescriptorModelProperty::getOperationMethod).ifPresent(operation -> {
                if (operation.isAnnotatedWith(Query.class)) {
                    this.enrichWithDsql(declaration, (MethodElement)operation);
                } else {
                    MetadataScopeAdapter metadataScope = new MetadataScopeAdapter(this.extensionType, (MethodElement)operation, declaration);
                    this.declareMetadataResolverFactory(declaration, metadataScope);
                    this.enrichMetadataKeyParameters(declaration, metadataScope.getKeysResolver().get());
                }
            });
        }

        private void enrichMetadataKeyParameters(ParameterizedDeclaration<?> declaration, TypeKeysResolver typeKeysResolver) {
            declaration.getAllParameters().forEach(paramDeclaration -> paramDeclaration.getModelProperty(ExtensionParameterDescriptorModelProperty.class).ifPresent(modelProperty -> this.parseMetadataKeyAnnotations(modelProperty.getExtensionParameter(), (BaseDeclaration)paramDeclaration, typeKeysResolver)));
        }

        private void declareMetadataResolverFactory(ComponentDeclaration<? extends ComponentDeclaration> declaration, MetadataScopeAdapter metadataScope) {
            MetadataResolverFactory metadataResolverFactory = this.getMetadataResolverFactory(metadataScope);
            declaration.addModelProperty(new MetadataResolverFactoryModelProperty(() -> metadataResolverFactory));
            this.declareMetadataKeyId(declaration, metadataScope.getKeysResolver());
            this.declareInputResolvers(declaration, metadataScope);
            if (declaration instanceof WithOutputDeclaration) {
                this.declareOutputResolvers((WithOutputDeclaration)((Object)declaration), metadataScope);
            }
        }

        private void enrichWithDsql(OperationDeclaration declaration, MethodElement method) {
            Query query = method.getAnnotation(Query.class).get();
            declaration.addModelProperty(new MetadataResolverFactoryModelProperty(() -> new QueryMetadataResolverFactory(query.nativeOutputResolver(), query.entityResolver())));
            this.addQueryModelProperties(declaration, query);
            this.declareDynamicType(declaration.getOutput());
            this.declareMetadataKeyId(declaration, () -> this.nullMetadataResolver);
            this.enrichMetadataKeyParameters(declaration, this.nullMetadataResolver);
        }

        private void addQueryModelProperties(OperationDeclaration declaration, Query query) {
            ParameterDeclaration parameterDeclaration = declaration.getAllParameters().stream().filter(p -> p.getModelProperty(ImplementingParameterModelProperty.class).isPresent()).filter(p -> p.getModelProperty(ImplementingParameterModelProperty.class).get().getParameter().isAnnotationPresent(MetadataKeyId.class)).findFirst().orElseThrow(() -> new IllegalParameterModelDefinitionException("Query operation must have a parameter annotated with @MetadataKeyId"));
            parameterDeclaration.addModelProperty(new QueryParameterModelProperty(query.translator()));
            parameterDeclaration.setLayoutModel(LayoutModel.builderFrom(parameterDeclaration.getLayoutModel()).asQuery().build());
        }

        private MetadataResolverFactory getMetadataResolverFactory(MetadataScopeAdapter scope) {
            return scope.isCustomScope() ? new DefaultMetadataResolverFactory(scope.getKeysResolver(), scope.getInputResolvers(), scope.getOutputResolver(), scope.getAttributesResolver()) : new NullMetadataResolverFactory();
        }

        private void declareInputResolvers(ComponentDeclaration<?> declaration, MetadataScopeAdapter metadataScope) {
            if (metadataScope.hasInputResolvers()) {
                Set<String> dynamicParameters = metadataScope.getInputResolvers().keySet();
                declaration.getAllParameters().stream().filter(p -> dynamicParameters.contains(p.getName())).forEach(this::declareDynamicType);
            }
        }

        private void declareOutputResolvers(WithOutputDeclaration declaration, MetadataScopeAdapter metadataScope) {
            if (metadataScope.hasOutputResolver()) {
                this.declareDynamicType(declaration.getOutput());
            }
            if (metadataScope.hasAttributesResolver()) {
                this.declareDynamicType(declaration.getOutputAttributes());
            }
        }

        private void declareDynamicType(TypedDeclaration component) {
            component.setType(component.getType(), true);
        }

        private void declareMetadataKeyId(ComponentDeclaration<? extends ComponentDeclaration> component, Supplier<? extends TypeKeysResolver> keysResolver) {
            this.getMetadataKeyModelProperty(component, keysResolver).ifPresent(component::addModelProperty);
        }

        private Optional<MetadataKeyIdModelProperty> getMetadataKeyModelProperty(ComponentDeclaration<? extends ComponentDeclaration> component, Supplier<? extends TypeKeysResolver> keysResolver) {
            String categoryName = DynamicMetadataDeclarationEnricher.this.getCategoryName(keysResolver);
            Optional<MetadataKeyIdModelProperty> keyId = this.findMetadataKeyIdInGroups(component, categoryName);
            return keyId.isPresent() ? keyId : this.findMetadataKeyIdInParameters(component, categoryName);
        }

        private Optional<MetadataKeyIdModelProperty> findMetadataKeyIdInGroups(ComponentDeclaration<? extends ComponentDeclaration> component, String categoryName) {
            return component.getParameterGroups().stream().map(group -> group.getModelProperty(ParameterGroupModelProperty.class).orElse(null)).filter(Objects::nonNull).filter(group -> group.getDescriptor().getAnnotatedContainer().isAnnotatedWith(MetadataKeyId.class)).map(group -> new MetadataKeyIdModelProperty(group.getDescriptor().getMetadataType(), group.getDescriptor().getName(), categoryName)).findFirst();
        }

        private Optional<MetadataKeyIdModelProperty> findMetadataKeyIdInParameters(ComponentDeclaration<? extends ComponentDeclaration> component, String categoryName) {
            return component.getParameterGroups().stream().flatMap(g -> g.getParameters().stream()).filter(p -> this.getExtensionParameter((ParameterDeclaration)p).map(element -> element.isAnnotatedWith(MetadataKeyId.class)).orElse(false)).map(p -> new MetadataKeyIdModelProperty(p.getType(), p.getName(), categoryName)).findFirst();
        }

        private Optional<ExtensionParameter> getExtensionParameter(ParameterDeclaration parameterDeclaration) {
            return parameterDeclaration.getModelProperty(ExtensionParameterDescriptorModelProperty.class).map(ExtensionParameterDescriptorModelProperty::getExtensionParameter);
        }

        private void parseMetadataKeyAnnotations(ExtensionParameter element, BaseDeclaration baseDeclaration, TypeKeysResolver keysResolver) {
            element.getValueFromAnnotation(MetadataKeyId.class).ifPresent(valueFetcher -> {
                boolean hasKeyResolver = !(keysResolver instanceof NullMetadataResolver);
                baseDeclaration.addModelProperty(new MetadataKeyPartModelProperty(1, hasKeyResolver));
            });
            element.getValueFromAnnotation(MetadataKeyPart.class).ifPresent(valueFetcher -> baseDeclaration.addModelProperty(new MetadataKeyPartModelProperty(valueFetcher.getNumberValue(MetadataKeyPart::order), valueFetcher.getBooleanValue(MetadataKeyPart::providedByKeyResolver))));
        }
    }
}

