/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.extension.api.annotation.notification.Fires;
import org.mule.runtime.extension.api.annotation.notification.NotificationActionProvider;
import org.mule.runtime.extension.api.annotation.notification.NotificationActions;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.model.notification.ImmutableNotificationModel;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class NotificationsDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.INITIALIZE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        Optional<ExtensionTypeDescriptorModelProperty> extensionType = declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class);
        String extensionNamespace = MuleExtensionUtils.getExtensionsNamespace(declaration);
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        if (extensionType.isPresent() && extensionType.get().getType().getDeclaringClass().isPresent()) {
            final Type extensionElement = extensionType.get().getType();
            Optional<NotificationActions> annotation = extensionElement.getAnnotation(NotificationActions.class);
            annotation.ifPresent(actionsAnnotation -> {
                final NotificationActionDefinition[] actions = (NotificationActionDefinition[])actionsAnnotation.value().getEnumConstants();
                final HashMap notificationModels = new HashMap();
                Arrays.stream(actions).forEach(action -> {
                    ImmutableNotificationModel model = new ImmutableNotificationModel(extensionNamespace, ((Enum)((Object)action)).name(), typeLoader.load(action.getDataType().getType()));
                    declaration.addNotificationModel(model);
                    notificationModels.put(action, model);
                });
                new IdempotentDeclarationWalker(){

                    @Override
                    public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                        Optional<ExtensionOperationDescriptorModelProperty> modelProperty = declaration.getModelProperty(ExtensionOperationDescriptorModelProperty.class);
                        if (modelProperty.isPresent()) {
                            MethodElement<? extends Type> method = modelProperty.get().getOperationMethod();
                            Optional<Fires> emitsNotifications = this.getOperationNotificationDeclaration(method, extensionElement);
                            this.includeNotificationDeclarationIfNeeded(declaration, emitsNotifications);
                        }
                    }

                    @Override
                    public void onSource(SourceDeclaration declaration) {
                        Optional<ExtensionTypeDescriptorModelProperty> modelProperty = declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class);
                        if (modelProperty.isPresent()) {
                            Type sourceContainer = modelProperty.get().getType();
                            Optional<Fires> emitsNotifications = this.getNotificationDeclaration(sourceContainer, extensionElement);
                            this.includeNotificationDeclarationIfNeeded(declaration, emitsNotifications);
                        }
                    }

                    private Optional<Fires> getOperationNotificationDeclaration(MethodElement operationMethod, Type extensionElement2) {
                        Object operationContainer = operationMethod.getEnclosingType();
                        return Optional.ofNullable(operationMethod.getAnnotation(Fires.class)).orElse(this.getNotificationDeclaration((Type)operationContainer, extensionElement2));
                    }

                    private Optional<Fires> getNotificationDeclaration(Type container, Type extensionElement2) {
                        return Optional.ofNullable(container.getAnnotation(Fires.class).orElseGet(() -> extensionElement2.getAnnotation(Fires.class).orElse(null)));
                    }

                    private void includeNotificationDeclarationIfNeeded(ExecutableComponentDeclaration declaration, Optional<Fires> emitsNotifications) {
                        emitsNotifications.ifPresent(emits -> {
                            Class<? extends NotificationActionProvider>[] providers = emits.value();
                            Arrays.stream(providers).forEach(provider -> {
                                try {
                                    NotificationActionProvider notificationActionProvider = (NotificationActionProvider)provider.newInstance();
                                    notificationActionProvider.getNotificationActions().stream().map(action -> this.validateEmits(actions, (NotificationActionDefinition)action)).forEach(action -> declaration.addNotificationModel((NotificationModel)notificationModels.get(action)));
                                }
                                catch (IllegalAccessException | InstantiationException e) {
                                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create NotificationActionProvider of type " + provider.getName()), (Throwable)e);
                                }
                            });
                        });
                    }

                    private NotificationActionDefinition validateEmits(NotificationActionDefinition[] actions2, NotificationActionDefinition action) {
                        Class<?> extensionAction = actions2.getClass().getComponentType();
                        if (!action.getClass().equals(extensionAction) && !action.getClass().getSuperclass().equals(extensionAction)) {
                            throw new IllegalModelDefinitionException(String.format("Invalid EmitsNotification detected, the extension declared firing notifications of %s type, but a notification of %s type has been detected", extensionAction, action.getClass()));
                        }
                        return action;
                    }
                }.walk(declaration);
            });
        }
    }
}

