/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.HasMessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedResult;
import reactor.core.publisher.Mono;

public class ImmutableProcessorChainExecutor
implements Chain,
HasMessageProcessors {
    private final MessageProcessorChain chain;
    private final CoreEvent originalEvent;

    public ImmutableProcessorChainExecutor(CoreEvent event, MessageProcessorChain chain) {
        this.originalEvent = event;
        this.chain = chain;
    }

    @Override
    public void process(Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        this.doProcess(this.originalEvent, onSuccess, onError);
    }

    @Override
    public void process(Object payload, Object attributes, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        CoreEvent customEvent = CoreEvent.builder(this.originalEvent).message(Message.builder().payload(TypedValue.of(payload)).attributes(TypedValue.of(attributes)).build()).build();
        this.doProcess(customEvent, onSuccess, onError);
    }

    @Override
    public void process(Result result, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        if (result instanceof EventedResult) {
            this.doProcess(((EventedResult)result).getEvent(), onSuccess, onError);
        } else {
            this.process(result.getOutput(), result.getAttributes(), onSuccess, onError);
        }
    }

    private void doProcess(CoreEvent event, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        Preconditions.checkArgument(onSuccess != null, "A success completion handler is required in order to execute the components chain, but it was null");
        Preconditions.checkArgument(onError != null, "An error completion handler is required in order to execute the components chain, but it was null");
        new Executor(this.chain, this.originalEvent, event, onSuccess, onError).execute();
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.chain.getMessageProcessors();
    }

    private static final class Executor {
        private final CoreEvent event;
        private final CoreEvent originalEvent;
        private final MessageProcessorChain chain;
        private final Consumer<Result> successHandler;
        private final BiConsumer<Throwable, Result> errorHandler;

        Executor(MessageProcessorChain chain, CoreEvent originalEvent, CoreEvent event, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
            this.chain = chain;
            this.event = event;
            this.originalEvent = originalEvent;
            this.successHandler = onSuccess;
            this.errorHandler = onError;
        }

        public void execute() {
            Mono.from(MessageProcessors.processWithChildContext(this.event, (ReactiveProcessor)this.chain, Optional.ofNullable(this.chain.getLocation()))).doOnSuccess(this::handleSuccess).doOnError(error -> {
                if (error instanceof MessagingException) {
                    this.handleError((Throwable)error, ((MessagingException)error).getEvent());
                } else {
                    this.handleError((Throwable)error, this.event);
                }
            }).subscribe();
        }

        private void handleSuccess(CoreEvent childEvent) {
            Result result = childEvent != null ? EventedResult.from(childEvent) : Result.builder().build();
            try {
                this.successHandler.accept(result);
            }
            catch (Throwable error) {
                this.errorHandler.accept(error, result);
            }
        }

        private CoreEvent handleError(Throwable error, CoreEvent childEvent) {
            try {
                this.errorHandler.accept(error, EventedResult.from(childEvent));
            }
            catch (Throwable e) {
                ((BaseEventContext)this.originalEvent.getContext()).error(e);
            }
            return null;
        }
    }
}

