/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverFactory;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.InterceptorFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.source.BackPressureAction;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.SourceFactory;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.InterceptorsModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceFactoryModelProperty;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationExecutorFactoryWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class MuleExtensionUtils {
    public static boolean returnsListOfMessages(HasOutputModel componentModel) {
        MetadataType outputType = componentModel.getOutput().getType();
        return outputType instanceof ArrayType && Message.class.getName().equals(ExtensionMetadataTypeUtils.getId(((ArrayType)outputType).getType()).orElse(null));
    }

    public static <T> boolean hasAnyDynamic(Iterable<ValueResolver<T>> resolvers) {
        for (ValueResolver<T> resolver : resolvers) {
            if (!resolver.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> toMap(ResolverSet resolverSet, CoreEvent event) throws MuleException {
        ValueResolvingContext ctx = ValueResolvingContext.from(event);
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<String, ValueResolver<?>> entry : resolverSet.getResolvers().entrySet()) {
            Object value = entry.getValue().resolve(ctx);
            if (value == null) continue;
            map.put((Object)entry.getKey(), value);
        }
        return map.build();
    }

    public static boolean isNullSafe(ParameterModel parameterModel) {
        return parameterModel.getModelProperty(NullSafeModelProperty.class).isPresent();
    }

    public static List<ConnectionProviderModel> getAllConnectionProviders(ExtensionModel extensionModel, ConfigurationModel configurationModel) {
        return ImmutableList.builder().addAll(configurationModel.getConnectionProviders()).addAll(extensionModel.getConnectionProviders()).build();
    }

    public static boolean supportsOAuth(ExtensionModel extensionModel) {
        final Reference connectionProvider = new Reference();
        new IdempotentExtensionWalker(){

            @Override
            protected void onConnectionProvider(ConnectionProviderModel model) {
                if (model.getModelProperty(OAuthModelProperty.class).isPresent()) {
                    connectionProvider.set(model);
                    this.stop();
                }
            }
        }.walk(extensionModel);
        return connectionProvider.get() != null;
    }

    public static List<Interceptor> createInterceptors(EnrichableModel model) {
        return model.getModelProperty(InterceptorsModelProperty.class).map(p -> MuleExtensionUtils.createInterceptors(p.getInterceptorFactories())).orElse((List)ImmutableList.of());
    }

    public static void addInterceptorFactory(BaseDeclaration declaration, InterceptorFactory interceptorFactory) {
        MuleExtensionUtils.getOrCreateInterceptorModelProperty(declaration).addInterceptorFactory(interceptorFactory);
    }

    public static void addInterceptorFactory(BaseDeclaration declaration, InterceptorFactory interceptorFactory, int position) {
        MuleExtensionUtils.getOrCreateInterceptorModelProperty(declaration).addInterceptorFactory(interceptorFactory, position);
    }

    private static InterceptorsModelProperty getOrCreateInterceptorModelProperty(BaseDeclaration declaration) {
        InterceptorsModelProperty property = declaration.getModelProperty(InterceptorsModelProperty.class).orElse(null);
        if (property == null) {
            property = new InterceptorsModelProperty(Collections.emptyList());
            declaration.addModelProperty(property);
        }
        return property;
    }

    public static List<Interceptor> createInterceptors(List<InterceptorFactory> interceptorFactories) {
        if (CollectionUtils.isEmpty(interceptorFactories)) {
            return ImmutableList.of();
        }
        return interceptorFactories.stream().map(InterceptorFactory::createInterceptor).collect(Collectors.toImmutableList());
    }

    public static ClassLoader getClassLoader(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader).orElse(Thread.currentThread().getContextClassLoader());
    }

    public static <T> T withExtensionClassLoader(ExtensionModel extensionModel, Callable<T> callable) throws Exception {
        return ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(extensionModel), callable);
    }

    public static byte toActionCode(OperationTransactionalAction action) {
        switch (action) {
            case ALWAYS_JOIN: {
                return 3;
            }
            case JOIN_IF_POSSIBLE: {
                return 4;
            }
            case NOT_SUPPORTED: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Unsupported action: " + action.name());
    }

    public static byte toActionCode(SourceTransactionalAction action) {
        switch (action) {
            case ALWAYS_BEGIN: {
                return 1;
            }
            case NONE: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unsupported action: " + action.name());
    }

    public static MessageSource.BackPressureStrategy toBackPressureStrategy(BackPressureMode mode) {
        switch (mode) {
            case WAIT: {
                return MessageSource.BackPressureStrategy.WAIT;
            }
            case FAIL: {
                return MessageSource.BackPressureStrategy.FAIL;
            }
            case DROP: {
                return MessageSource.BackPressureStrategy.DROP;
            }
        }
        throw new IllegalArgumentException("Unmapped mode " + mode.name());
    }

    public static MessageSource.BackPressureStrategy toBackPressureStrategy(String backPressureModeName) {
        return MuleExtensionUtils.toBackPressureStrategy(BackPressureMode.valueOf(backPressureModeName));
    }

    public static Optional<BackPressureAction> toBackPressureAction(MessageSource.BackPressureStrategy backPressureStrategy) {
        if (backPressureStrategy == MessageSource.BackPressureStrategy.FAIL) {
            return Optional.of(BackPressureAction.FAIL);
        }
        if (backPressureStrategy == MessageSource.BackPressureStrategy.DROP) {
            return Optional.of(BackPressureAction.DROP);
        }
        if (backPressureStrategy == MessageSource.BackPressureStrategy.WAIT) {
            return Optional.empty();
        }
        throw new IllegalArgumentException("Unsupported BackPressureStrategy " + (Object)((Object)backPressureStrategy));
    }

    public static ConfigurationFactory getConfigurationFactory(ConfigurationModel configurationModel) {
        return MuleExtensionUtils.fromModelProperty(configurationModel, ConfigurationFactoryModelProperty.class, ConfigurationFactoryModelProperty::getConfigurationFactory, () -> new IllegalConfigurationModelDefinitionException(String.format("Configuration '%s' does not provide a %s", configurationModel.getName(), ConfigurationFactory.class.getName())));
    }

    public static MetadataResolverFactory getMetadataResolverFactory(EnrichableModel model) {
        return model.getModelProperty(MetadataResolverFactoryModelProperty.class).map(MetadataResolverFactoryModelProperty::getMetadataResolverFactory).orElse(new NullMetadataResolverFactory());
    }

    public static <T extends ComponentModel> ComponentExecutorFactory<T> getOperationExecutorFactory(T operationModel) {
        ComponentExecutorFactory executorFactory = MuleExtensionUtils.fromModelProperty(operationModel, ComponentExecutorModelProperty.class, ComponentExecutorModelProperty::getExecutorFactory, () -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not provide a %s", operationModel.getName(), ComponentExecutorFactory.class.getSimpleName())));
        return new OperationExecutorFactoryWrapper(executorFactory, MuleExtensionUtils.createInterceptors(operationModel));
    }

    public static SourceFactory getSourceFactory(SourceModel sourceModel) {
        return MuleExtensionUtils.fromModelProperty(sourceModel, SourceFactoryModelProperty.class, SourceFactoryModelProperty::getSourceFactory, () -> new IllegalSourceModelDefinitionException(String.format("Source '%s' does not provide a %s", sourceModel.getName(), SourceFactory.class.getSimpleName())));
    }

    public static ConnectionProviderFactory getConnectionProviderFactory(ConnectionProviderModel connectionProviderModel) {
        return MuleExtensionUtils.fromModelProperty(connectionProviderModel, ConnectionProviderFactoryModelProperty.class, ConnectionProviderFactoryModelProperty::getConnectionProviderFactory, () -> new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider '%s' does not provide a %s", connectionProviderModel.getName(), ConnectionProviderFactory.class.getSimpleName())));
    }

    public static Type getConnectionType(ConnectionProviderModel connectionProviderModel) {
        return MuleExtensionUtils.fromModelProperty(connectionProviderModel, ConnectionTypeModelProperty.class, ConnectionTypeModelProperty::getConnectionTypeElement, () -> new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider '%s' does not specify a connection type", connectionProviderModel.getName())));
    }

    private static <T, P extends ModelProperty> T fromModelProperty(EnrichableModel model, Class<P> modelPropertyType, Function<P, T> map, Supplier<? extends RuntimeException> exceptionSupplier) {
        return model.getModelProperty(modelPropertyType).map(map).orElseThrow(exceptionSupplier);
    }

    public static String getExtensionsNamespace(ExtensionModel extensionModel) {
        return MuleExtensionUtils.getExtensionsNamespace(extensionModel.getXmlDslModel());
    }

    public static String getExtensionsNamespace(ExtensionDeclaration extensionDeclaration) {
        return MuleExtensionUtils.getExtensionsNamespace(extensionDeclaration.getXmlDslModel());
    }

    private static String getExtensionsNamespace(XmlDslModel dslModel) {
        return dslModel.getPrefix().toUpperCase();
    }

    public static ExtensionModel loadExtension(Class<?> clazz) {
        return MuleExtensionUtils.loadExtension(clazz, new HashMap<String, Object>());
    }

    public static ExtensionModel loadExtension(Class<?> clazz, Map<String, Object> params) {
        params.put("type", clazz.getName());
        params.put("version", "4.0.0-SNAPSHOT");
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.emptySet());
        return new DefaultJavaExtensionModelLoader().loadExtensionModel(clazz.getClassLoader(), dslResolvingContext, params);
    }

    public static String getImplicitConfigurationProviderName(ExtensionModel extensionModel, ConfigurationModel implicitConfigurationModel) {
        return String.format("%s-%s-implicit", extensionModel.getName(), implicitConfigurationModel.getName());
    }

    public static boolean isExpression(Object value) {
        if (value instanceof String) {
            String trim = ((String)value).trim();
            return trim.startsWith("#[") && trim.endsWith("]");
        }
        return false;
    }
}

